/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.internal;

import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.impl.BatchLanguageProcessor;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.internal.JavaAnnotationSuppressor;
import net.sourceforge.pmd.lang.java.internal.JavaDesignerBindings;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProperties;
import net.sourceforge.pmd.lang.java.internal.JavaMetricsProvider;
import net.sourceforge.pmd.lang.java.internal.JavaViolationDecorator;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.BaseContextNodeTestFun;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.GetCommentOnFunction;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.GetModifiersFun;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.MatchesSignatureFunction;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.MetricFunction;
import net.sourceforge.pmd.lang.java.rule.xpath.internal.NodeIsFunction;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.designerbindings.DesignerBindings;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLanguageProcessor
extends BatchLanguageProcessor<JavaLanguageProperties>
implements LanguageVersionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLanguageProcessor.class);
    private final LanguageMetricsProvider myMetricsProvider = new JavaMetricsProvider();
    private final JavaParser parser;
    private final JavaParser parserWithoutProcessing;
    private final boolean firstClassLombok;
    private TypeSystem typeSystem;
    private static final XPathHandler XPATH_HANDLER = XPathHandler.getHandlerForFunctionDefs((XPathFunctionDefinition)BaseContextNodeTestFun.TYPE_IS_EXACTLY, (XPathFunctionDefinition[])new XPathFunctionDefinition[]{BaseContextNodeTestFun.TYPE_IS, BaseContextNodeTestFun.HAS_ANNOTATION, MatchesSignatureFunction.INSTANCE, NodeIsFunction.INSTANCE, GetModifiersFun.GET_EFFECTIVE, GetModifiersFun.GET_EXPLICIT, MetricFunction.INSTANCE, GetCommentOnFunction.INSTANCE});

    public JavaLanguageProcessor(JavaLanguageProperties properties, TypeSystem typeSystem) {
        super((LanguagePropertyBundle)properties);
        this.typeSystem = typeSystem;
        String suppressMarker = properties.getSuppressMarker();
        this.parser = new JavaParser(suppressMarker, this, true);
        this.parserWithoutProcessing = new JavaParser(suppressMarker, this, false);
        this.firstClassLombok = (Boolean)properties.getProperty(JavaLanguageProperties.FIRST_CLASS_LOMBOK);
    }

    public JavaLanguageProcessor(JavaLanguageProperties properties) {
        this(properties, TypeSystem.usingClassLoaderClasspath(properties.getAnalysisClassLoader()));
        LOG.debug("Using analysis classloader: {}", (Object)properties.getAnalysisClassLoader());
    }

    public @NonNull LanguageVersionHandler services() {
        return this;
    }

    public Parser getParser() {
        return this.parser;
    }

    public JavaParser getParserWithoutProcessing() {
        return this.parserWithoutProcessing;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public boolean hasFirstClassLombokSupport() {
        return this.firstClassLombok;
    }

    TypeInferenceLogger newTypeInfLogger() {
        JavaLanguageProperties.InferenceLoggingVerbosity verbosity = (JavaLanguageProperties.InferenceLoggingVerbosity)((Object)((JavaLanguageProperties)this.getProperties()).getProperty(JavaLanguageProperties.INTERNAL_INFERENCE_LOGGING_VERBOSITY));
        if (verbosity == JavaLanguageProperties.InferenceLoggingVerbosity.VERBOSE) {
            return new TypeInferenceLogger.VerboseLogger(System.err);
        }
        if (verbosity == JavaLanguageProperties.InferenceLoggingVerbosity.SIMPLE) {
            return new TypeInferenceLogger.SimpleLogger(System.err);
        }
        return TypeInferenceLogger.noop();
    }

    public DesignerBindings getDesignerBindings() {
        return JavaDesignerBindings.INSTANCE;
    }

    public XPathHandler getXPathHandler() {
        return XPATH_HANDLER;
    }

    public List<ViolationSuppressor> getExtraViolationSuppressors() {
        return JavaAnnotationSuppressor.ALL_JAVA_SUPPRESSORS;
    }

    public ViolationDecorator getViolationDecorator() {
        return JavaViolationDecorator.INSTANCE;
    }

    public LanguageMetricsProvider getLanguageMetricsProvider() {
        return this.myMetricsProvider;
    }

    public void setTypeSystem(TypeSystem ts) {
        this.typeSystem = Objects.requireNonNull(ts);
    }

    public void close() throws Exception {
        this.typeSystem.logStats();
        super.close();
    }
}

