/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.security;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.IvParameterSpec;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

public class InsecureCryptoIvRule
extends AbstractJavaRule {
    public InsecureCryptoIvRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceBodyDeclaration.class);
    }

    @Override
    public Object visit(ASTClassOrInterfaceBodyDeclaration node, Object data) {
        HashSet<ASTLocalVariableDeclaration> foundLocalVars = new HashSet<ASTLocalVariableDeclaration>();
        HashSet<String> passedInIvVarNames = new HashSet<String>();
        List allocations = node.findDescendantsOfType(ASTAllocationExpression.class);
        for (Object allocation : allocations) {
            ASTName name;
            ASTPrimaryExpression init;
            Class<?> foundClass;
            ASTClassOrInterfaceType declClassName = (ASTClassOrInterfaceType)allocation.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (declClassName == null || (foundClass = declClassName.getType()) == null || !IvParameterSpec.class.isAssignableFrom(foundClass) || (init = (ASTPrimaryExpression)allocation.getFirstDescendantOfType(ASTPrimaryExpression.class)) == null || (name = (ASTName)init.getFirstDescendantOfType(ASTName.class)) == null) continue;
            passedInIvVarNames.add(name.getImage());
        }
        List localVars = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        for (ASTLocalVariableDeclaration localVar : localVars) {
            foundLocalVars.addAll(this.extractPrimitiveTypes(localVar));
        }
        Map globalDecls = node.getScope().getDeclarations(VariableNameDeclaration.class);
        for (VariableNameDeclaration fieldVar : globalDecls.keySet()) {
            ASTVariableDeclarator var;
            if (!passedInIvVarNames.contains(fieldVar.getNode().getImage()) || (var = (ASTVariableDeclarator)fieldVar.getNode().getFirstParentOfType(ASTVariableDeclarator.class)) == null) continue;
            this.validateProperIv(data, (ASTVariableInitializer)var.getFirstDescendantOfType(ASTVariableInitializer.class));
        }
        for (ASTLocalVariableDeclaration foundLocalVar : foundLocalVars) {
            if (!passedInIvVarNames.contains(foundLocalVar.getVariableName())) continue;
            this.validateProperIv(data, (ASTVariableInitializer)foundLocalVar.getFirstDescendantOfType(ASTVariableInitializer.class));
        }
        return data;
    }

    private Set<ASTLocalVariableDeclaration> extractPrimitiveTypes(ASTLocalVariableDeclaration localVar) {
        List types = localVar.findDescendantsOfType(ASTPrimitiveType.class);
        HashSet<ASTLocalVariableDeclaration> retVal = new HashSet<ASTLocalVariableDeclaration>();
        this.extractPrimitiveTypesInner(retVal, localVar, types);
        return retVal;
    }

    private <T> void extractPrimitiveTypesInner(Set<T> retVal, T field, List<ASTPrimitiveType> types) {
        for (ASTPrimitiveType type : types) {
            ASTReferenceType parent;
            if (!type.hasImageEqualTo("byte") || (parent = (ASTReferenceType)type.getFirstParentOfType(ASTReferenceType.class)) == null) continue;
            retVal.add(field);
        }
    }

    private void validateProperIv(Object data, ASTVariableInitializer varInit) {
        ASTLiteral literal;
        ASTArrayInitializer arrayInit = (ASTArrayInitializer)varInit.getFirstDescendantOfType(ASTArrayInitializer.class);
        if (arrayInit != null) {
            this.addViolation(data, (Node)varInit);
        }
        if ((literal = (ASTLiteral)varInit.getFirstDescendantOfType(ASTLiteral.class)) != null && literal.isStringLiteral()) {
            this.addViolation(data, (Node)varInit);
        }
    }
}

