/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.util.NumericConstants;

public class MoreThanOneLoggerRule
extends AbstractJavaRule {
    private static final String LOG4J_LOGGER_NAME = "org.apache.log4j.Logger";
    private static final String JAVA_LOGGER_NAME = "java.util.logging.Logger";
    private static final String SLF4J_LOGGER_NAME = "org.slf4j.Logger";
    private Stack<Integer> stack = new Stack();
    private Integer count;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        return this.init(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        return this.init(node, data);
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        return this.init(node, data);
    }

    private Object init(JavaNode node, Object data) {
        this.stack.push(this.count);
        this.count = NumericConstants.ZERO;
        node.childrenAccept(this, data);
        if (this.count > 1) {
            this.addViolation(data, (Node)node);
        }
        this.count = this.stack.pop();
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclarator node, Object data) {
        Class<?> clazzType;
        Node classOrIntType;
        Node reftypeNode;
        if (this.count > 1) {
            return super.visit(node, data);
        }
        Node type = (Node)node.jjtGetParent().getFirstChildOfType(ASTType.class);
        if (type != null && (reftypeNode = type.jjtGetChild(0)) instanceof ASTReferenceType && (classOrIntType = reftypeNode.jjtGetChild(0)) instanceof ASTClassOrInterfaceType && ((clazzType = ((ASTClassOrInterfaceType)classOrIntType).getType()) != null && (TypeHelper.isA((TypeNode)((ASTClassOrInterfaceType)classOrIntType), LOG4J_LOGGER_NAME) || TypeHelper.isA((TypeNode)((ASTClassOrInterfaceType)classOrIntType), JAVA_LOGGER_NAME) || TypeHelper.isA((TypeNode)((ASTClassOrInterfaceType)classOrIntType), SLF4J_LOGGER_NAME)) || clazzType == null && "Logger".equals(classOrIntType.getImage()))) {
            this.count = this.count + 1;
        }
        return super.visit(node, data);
    }
}

