/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;
import net.sourceforge.pmd.util.StringUtil;

public class ClassNamingConventionsRule
extends AbstractJavaRule {
    private static final RegexProperty CLASS_REGEX = ((RegexProperty.RegexPBuilder)ClassNamingConventionsRule.defaultProp("class").desc("Regex which applies to concrete class names")).build();
    private static final RegexProperty ABSTRACT_CLASS_REGEX = ClassNamingConventionsRule.defaultProp("abstract class").build();
    private static final RegexProperty INTERFACE_REGEX = ClassNamingConventionsRule.defaultProp("interface").build();
    private static final RegexProperty ENUMERATION_REGEX = ClassNamingConventionsRule.defaultProp("enum").build();
    private static final RegexProperty ANNOTATION_REGEX = ClassNamingConventionsRule.defaultProp("annotation").build();
    private static final RegexProperty UTILITY_CLASS_REGEX = ClassNamingConventionsRule.defaultProp("utility class").defaultValue("[A-Z][a-zA-Z]+Util").build();

    public ClassNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CLASS_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)ABSTRACT_CLASS_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)INTERFACE_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)ENUMERATION_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)ANNOTATION_REGEX);
        this.definePropertyDescriptor((PropertyDescriptor)UTILITY_CLASS_REGEX);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
        this.addRuleChainVisit(ASTEnumDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationTypeDeclaration.class);
    }

    private void checkMatches(ASTAnyTypeDeclaration node, PropertyDescriptor<Pattern> regex, Object data) {
        if (!((Pattern)this.getProperty(regex)).matcher(node.getImage()).matches()) {
            this.addViolation(data, node, new Object[]{this.isUtilityClass(node) ? "utility class" : node.getTypeKind().getPrintableName(), node.getImage(), ((Pattern)this.getProperty(regex)).toString()});
        }
    }

    private boolean isUtilityClass(ASTAnyTypeDeclaration node) {
        if (node.getTypeKind() != ASTAnyTypeDeclaration.TypeKind.CLASS) {
            return false;
        }
        boolean hasAny = false;
        for (ASTAnyTypeBodyDeclaration decl : node.getDeclarations()) {
            switch (decl.getKind()) {
                case FIELD: 
                case METHOD: {
                    hasAny = true;
                    if (((AccessNode)((Object)decl.getDeclarationNode())).isStatic()) break;
                    return false;
                }
                case INITIALIZER: {
                    if (((ASTInitializer)decl.getDeclarationNode()).isStatic()) break;
                    return false;
                }
            }
        }
        return hasAny;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)ABSTRACT_CLASS_REGEX, data);
        } else if (this.isUtilityClass(node)) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)UTILITY_CLASS_REGEX, data);
        } else if (node.isInterface()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)INTERFACE_REGEX, data);
        } else {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)CLASS_REGEX, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        this.checkMatches(node, (PropertyDescriptor<Pattern>)ENUMERATION_REGEX, data);
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        this.checkMatches(node, (PropertyDescriptor<Pattern>)ANNOTATION_REGEX, data);
        return data;
    }

    private static RegexProperty.RegexPBuilder defaultProp(String name) {
        return ((RegexProperty.RegexPBuilder)RegexProperty.named((String)(StringUtil.toCamelCase((String)name) + "Pattern")).desc("Regex which applies to " + name.trim() + " names")).defaultValue("[A-Z][a-zA-Z]+");
    }
}

