/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.pdf.classic;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.pdf.classic.ClassicPdfUtils;
import net.sf.jasperreports.pdf.common.LineCapStyle;
import net.sf.jasperreports.pdf.common.PdfContent;

public class ClassicPdfContent
implements PdfContent {
    private PdfWriter pdfWriter;
    private PdfContentByte pdfContentByte;
    private ColorSpace cmykColorSpace;
    private PdfGState[] fillAlphaStates = new PdfGState[256];
    private boolean fillAlphaSet = false;
    private PdfGState[] strokeAlphaStates = new PdfGState[256];
    private boolean strokeAlphaSet = false;

    public ClassicPdfContent(PdfWriter pdfWriter, ColorSpace cmykColorSpace) {
        this.pdfWriter = pdfWriter;
        this.pdfContentByte = pdfWriter.getDirectContent();
        this.cmykColorSpace = cmykColorSpace;
    }

    public PdfContentByte getPdfContentByte() {
        return this.pdfContentByte;
    }

    public void refreshContent() {
        this.pdfContentByte = this.pdfWriter.getDirectContent();
    }

    @Override
    public void setFillColor(Color color) {
        this.setFillColorAlpha(color.getAlpha());
        this.pdfContentByte.setColorFill(ClassicPdfUtils.convertColor(this.cmykColorSpace, color));
    }

    @Override
    public void setFillColorAlpha(int alpha) {
        if (alpha != 255) {
            this.setFillAlpha(alpha);
            this.fillAlphaSet = true;
        }
    }

    @Override
    public void resetFillColor() {
        if (this.fillAlphaSet) {
            this.setFillAlpha(255);
            this.fillAlphaSet = false;
        }
    }

    protected void setFillAlpha(int alpha) {
        PdfGState state = this.fillAlphaStates[alpha];
        if (state == null) {
            state = new PdfGState();
            state.setFillOpacity((float)alpha / 255.0f);
            this.fillAlphaStates[alpha] = state;
        }
        this.pdfContentByte.setGState(state);
    }

    @Override
    public void setStrokeColor(Color color) {
        int alpha = color.getAlpha();
        if (alpha != 255) {
            this.setStrokeAlpha(alpha);
            this.strokeAlphaSet = true;
        }
        this.pdfContentByte.setColorStroke(ClassicPdfUtils.convertColor(this.cmykColorSpace, color));
    }

    @Override
    public void resetStrokeColor() {
        if (this.strokeAlphaSet) {
            this.setStrokeAlpha(255);
            this.strokeAlphaSet = false;
        }
    }

    protected void setStrokeAlpha(int alpha) {
        PdfGState state = this.strokeAlphaStates[alpha];
        if (state == null) {
            state = new PdfGState();
            state.setStrokeOpacity((float)alpha / 255.0f);
            this.strokeAlphaStates[alpha] = state;
        }
        this.pdfContentByte.setGState(state);
    }

    @Override
    public void setLineWidth(float lineWidth) {
        this.pdfContentByte.setLineWidth(lineWidth);
    }

    @Override
    public void setLineCap(LineCapStyle lineCap) {
        int lineCapValue;
        switch (lineCap) {
            case BUTT: {
                lineCapValue = 0;
                break;
            }
            case ROUND: {
                lineCapValue = 1;
                break;
            }
            case PROJECTING_SQUARE: {
                lineCapValue = 2;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown line cap style " + (Object)((Object)lineCap));
            }
        }
        this.pdfContentByte.setLineCap(lineCapValue);
    }

    @Override
    public void setLineDash(float phase) {
        this.pdfContentByte.setLineDash(phase);
    }

    @Override
    public void setLineDash(float unitsOn, float unitsOff, float phase) {
        this.pdfContentByte.setLineDash(unitsOn, unitsOff, phase);
    }

    @Override
    public void strokeLine(float x1, float y1, float x2, float y2) {
        this.pdfContentByte.moveTo(x1, y1);
        this.pdfContentByte.lineTo(x2, y2);
        this.pdfContentByte.stroke();
    }

    @Override
    public void fillRectangle(float x, float y, float width, float height) {
        this.pdfContentByte.rectangle(x, y, width, height);
        this.pdfContentByte.fill();
    }

    @Override
    public void fillRoundRectangle(float x, float y, float width, float height, float radius) {
        this.pdfContentByte.roundRectangle(x, y, width, height, radius);
        this.pdfContentByte.fill();
    }

    @Override
    public void strokeRoundRectangle(float x, float y, float width, float height, float radius) {
        this.pdfContentByte.roundRectangle(x, y, width, height, radius);
        this.pdfContentByte.stroke();
    }

    @Override
    public void fillEllipse(float x1, float y1, float x2, float y2) {
        this.pdfContentByte.ellipse(x1, y1, x2, y2);
        this.pdfContentByte.fill();
    }

    @Override
    public void strokeEllipse(float x1, float y1, float x2, float y2) {
        this.pdfContentByte.ellipse(x1, y1, x2, y2);
        this.pdfContentByte.stroke();
    }

    @Override
    public void setLiteral(String string) {
        this.pdfContentByte.setLiteral(string);
    }

    @Override
    public void transform(AffineTransform atrans) {
        this.pdfContentByte.transform(atrans);
    }
}

