/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.pdf;

import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMeta;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.options.PropertyOptions;
import com.adobe.internal.xmp.options.SerializeOptions;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.pdf.type.PdfaConformanceEnum;

class XmpWriter {
    private static final String FORMAT_PDF = "application/pdf";
    private static final String PDF_PRODUCER = "Producer";
    private static final String PDF_KEYWORDS = "Keywords";
    private static final String PDFA_PART = "part";
    private static final String PDFA_CONFORMANCE = "conformance";
    private static final String PDFA_PART_1 = "1";
    private static final String PDFA_PART_2 = "2";
    private static final String PDFA_PART_3 = "3";
    private static final String PDFA_CONFORMANCE_A = "A";
    private static final String PDFA_CONFORMANCE_B = "B";
    private static final String PDFA_CONFORMANCE_U = "U";
    private static final String XMP_CREATE_DATE = "CreateDate";
    private static final String XMP_MODIFY_DATE = "ModifyDate";
    private static final String XMP_CREATOR_TOOL = "CreatorTool";
    private final PdfWriter pdfWriter;
    private final PdfDictionary info;
    private final PdfaConformanceEnum conformance;

    XmpWriter(PdfWriter pdfWriter, PdfaConformanceEnum conformance) {
        this.pdfWriter = pdfWriter;
        this.info = pdfWriter.getInfo();
        this.conformance = conformance;
    }

    byte[] createXmpMetadata() {
        try {
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            XMPMeta xmp = XMPMetaFactory.create();
            xmp.setObjectName("");
            xmp.setProperty("http://purl.org/dc/elements/1.1/", "dc:format", (Object)FORMAT_PDF);
            String producer = this.extractInfo(PdfName.PRODUCER);
            if (producer != null) {
                xmp.setProperty("http://ns.adobe.com/pdf/1.3/", PDF_PRODUCER, (Object)producer);
            }
            if (this.pdfWriter.getPDFXConformance() == 3 || this.conformance == PdfaConformanceEnum.PDFA_1A) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_1);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_A);
            } else if (this.pdfWriter.getPDFXConformance() == 4 || this.conformance == PdfaConformanceEnum.PDFA_1B) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_1);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_B);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_2A) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_2);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_A);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_2B) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_2);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_B);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_2U) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_2);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_U);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_3A) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_3);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_A);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_3B) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_3);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_B);
            } else if (this.conformance == PdfaConformanceEnum.PDFA_3U) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_3);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_U);
            }
            xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_CREATE_DATE, (Object)((PdfDate)this.info.get(PdfName.CREATIONDATE)).getW3CDate());
            PdfDate modifiedDate = (PdfDate)this.info.get(PdfName.MODDATE);
            if (modifiedDate != null) {
                xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_MODIFY_DATE, (Object)modifiedDate.getW3CDate());
            }
            if ((title = this.extractInfo(PdfName.TITLE)) != null) {
                xmp.setLocalizedText("http://purl.org/dc/elements/1.1/", "dc:title", "x-default", "x-default", title);
            }
            if ((author = this.extractInfo(PdfName.AUTHOR)) != null) {
                PropertyOptions arrayOrdered = new PropertyOptions().setArrayOrdered(true);
                xmp.appendArrayItem("http://purl.org/dc/elements/1.1/", "dc:creator", arrayOrdered, author, null);
            }
            if ((subject = this.extractInfo(PdfName.SUBJECT)) != null) {
                PropertyOptions array = new PropertyOptions().setArray(true);
                xmp.appendArrayItem("http://purl.org/dc/elements/1.1/", "dc:subject", array, subject, null);
                xmp.setLocalizedText("http://purl.org/dc/elements/1.1/", "dc:description", "x-default", "x-default", subject);
            }
            if ((keywords = this.extractInfo(PdfName.KEYWORDS)) != null) {
                xmp.setProperty("http://ns.adobe.com/pdf/1.3/", PDF_KEYWORDS, (Object)keywords);
            }
            if ((creator = this.extractInfo(PdfName.CREATOR)) != null) {
                xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_CREATOR_TOOL, (Object)creator);
            }
            SerializeOptions options = new SerializeOptions();
            options.setUseCanonicalFormat(true);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            XMPMetaFactory.serialize((XMPMeta)xmp, (OutputStream)out, (SerializeOptions)options);
            return out.toByteArray();
        }
        catch (XMPException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    private String extractInfo(PdfName key) {
        PdfString value = (PdfString)this.info.get(key);
        return value == null ? null : value.toUnicodeString();
    }
}

