/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class RadioButton {
    private static final String BY_ID = "css:input[id='{0}' i],input[data-test='{0}' i],[aria-label='{0}' i]";
    private static final String BY_NAME = "css:input[name='{0}' i]";
    private static final String BY_VALUE = "css:input[type='radio'][value='{0}' i]";
    private static final String ARIA_LABEL = "[aria-label='{0}' i]";

    public static SearchableTarget withId(String id) {
        return Target.the("the '" + id + "' radio button").locatedBy(BY_ID).of(id);
    }

    public static SearchableTarget withName(String name) {
        return Target.the("the '" + name + "' radio button").locatedBy(BY_NAME).of(name);
    }

    public static SearchableTarget withValue(String value) {
        return Target.the("the '" + value + "' radio button").locatedBy(BY_VALUE).of(value);
    }

    public static SearchableTarget withLabel(String labelText) {
        return Target.the("the '" + labelText + " radio button").locatedBy(LocatorStrategies.fieldWithLabel(labelText));
    }

    public static SearchableTarget withAriaLabel(String name) {
        return Target.the("'" + name + "' radio button").locatedByFirstMatching("css:[aria-label='{0}' i]").of(name);
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("radio button").withCSSClass(className);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("radio button").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("radio button").locatedBy(selector);
    }
}

