/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.LocatorStrategies;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class PageElement {
    private static final String BY_NAME_ID_OR_ARIA_LABEL = "css:[id='{0}' i],[name='{0}' i],[data-test='{0}' i],[aria-label='{0}' i]";

    public static SearchableTarget withNameOrId(String name) {
        return Target.the("the '" + name + "' element").locatedBy(BY_NAME_ID_OR_ARIA_LABEL).of(name);
    }

    public static SearchableTarget containingText(String cssOrXPathLocator, String text) {
        return Target.the("the element containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndMatchingCSS(cssOrXPathLocator, text));
    }

    public static SearchableTarget containingTextIgnoringCase(String cssOrXPathLocator, String text) {
        return Target.the("the element containing text '" + text + "'").locatedBy(LocatorStrategies.containingTextAndMatchingCSSIgnoringCase(cssOrXPathLocator, text));
    }

    public static SearchableTarget withCSSClass(String className) {
        return TargetFactory.forElementOfType("element").withCSSClass(className);
    }

    public static SearchableTarget containingText(String text) {
        return TargetFactory.forElementOfType("element").containingText(text);
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("element").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("element").locatedBy(selector);
    }
}

