/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionSubject;
import net.serenitybdd.screenplay.exceptions.IgnoreStepException;
import net.thucydides.core.steps.StepEventBus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class Consequence<T> {
    private final Question<T> actual;
    private final Matcher<T> expected;
    private final String subject;

    protected Consequence(Question<T> actual, Matcher<T> expected) {
        this.actual = actual;
        this.expected = expected;
        this.subject = QuestionSubject.fromClass(actual.getClass()).andQuestion(actual).subject();
    }

    public void evaluateFor(Actor actor) {
        this.ensureThisStepShouldNotBeIgnored();
        MatcherAssert.assertThat(this.actual.answeredBy(actor), this.expected);
    }

    private void ensureThisStepShouldNotBeIgnored() {
        if (StepEventBus.getEventBus().currentTestIsSuspended() || StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            throw new IgnoreStepException();
        }
    }

    public String toString() {
        return String.format("Then %s should be %s", this.subject, this.expected);
    }
}

