/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import com.google.common.collect.Maps;
import java.util.Map;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.PerformedTaskTally;
import net.serenitybdd.screenplay.PerformsTasks;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.exceptions.IgnoreStepException;

public class Actor
implements PerformsTasks {
    private final String name;
    private final PerformedTaskTally taskTally = new PerformedTaskTally();
    private EventBusInterface eventBusInterface = new EventBusInterface();
    private Map<String, Object> notepad = Maps.newHashMap();
    private Map<Class, Ability> abilities = Maps.newHashMap();

    public Actor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Actor named(String name) {
        return new Actor(name);
    }

    public <T extends Ability> Actor can(T doSomething) {
        this.abilities.put(doSomething.getClass(), doSomething);
        return this;
    }

    public <T extends Ability> T abilityTo(Class<? extends T> doSomething) {
        return (T)this.abilities.get(doSomething);
    }

    @SafeVarargs
    public final <T extends Performable> void has(T ... todos) {
        this.attemptsTo((Performable[])todos);
    }

    @Override
    @SafeVarargs
    public final <T extends Performable> void attemptsTo(T ... todos) {
        for (T todo : todos) {
            this.perform(todo);
        }
    }

    @Override
    public <ANSWER> ANSWER asksFor(Question<ANSWER> question) {
        return question.answeredBy(this);
    }

    private <T extends Performable> void perform(T todo) {
        try {
            this.taskTally.newTask();
            todo.performAs((Actor)this);
            if (this.anOutOfStepErrorOccurred()) {
                this.eventBusInterface.mergePreviousStep();
            }
        }
        catch (Throwable e) {
            this.eventBusInterface.reportStepFailureFor((Performable)todo, e);
        }
        finally {
            this.eventBusInterface.updateOverallResult();
        }
    }

    @SafeVarargs
    public final <T> void should(Consequence<T> ... consequences) {
        for (Consequence<T> consequence : consequences) {
            this.check(consequence);
        }
    }

    private boolean anOutOfStepErrorOccurred() {
        return this.eventBusInterface.getStepCount() > this.taskTally.getPerformedTaskCount();
    }

    private <T> void check(Consequence<T> consequence) {
        try {
            this.eventBusInterface.reportNewStepWithTitle(consequence.toString());
            consequence.evaluateFor(this);
            this.eventBusInterface.reportStepFinished();
        }
        catch (IgnoreStepException e) {
            this.eventBusInterface.reportStepIgnored();
        }
        catch (Throwable e) {
            this.eventBusInterface.reportStepFailureFor(consequence, e);
        }
    }

    public <ANSWER> void remember(String key, Question<ANSWER> question) {
        ANSWER answer = this.asksFor(question);
        this.notepad.put(key, answer);
    }

    public void remember(String key, Object value) {
        this.notepad.put(key, value);
    }

    public <T> T recall(String key) {
        return (T)this.notepad.get(key);
    }

    public <T> T sawAsThe(String key) {
        return this.recall(key);
    }

    public <T> T gaveAsThe(String key) {
        return this.recall(key);
    }
}

