/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.zephyr.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.plugins.jira.service.JIRAConfiguration;
import net.serenitybdd.plugins.jira.service.JIRAConnection;
import net.serenitybdd.plugins.jira.service.JiraIssueTracker;
import net.serenitybdd.plugins.jira.zephyr.ZephyrDateParser;
import net.serenitybdd.plugins.jira.zephyr.ZephyrUpdater;
import net.serenitybdd.plugins.jira.zephyr.client.HttpClient;
import net.serenitybdd.plugins.jira.zephyr.client.ZephyrClient;
import net.serenitybdd.plugins.jira.zephyr.domain.ZephyrCycle;
import net.serenitybdd.plugins.jira.zephyr.domain.ZephyrExecutionDetails;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZephyrRestClient
implements ZephyrClient {
    private String zapiUrl;
    private String creds;
    private final Logger logger;
    private static final String ZAPI_LABEL = "label";
    private static final String ZAPI_VALUE = "value";
    private static final int MIN_TEST_SCENARIO_DELAY = 1800000;

    @Inject
    public ZephyrRestClient(JIRAConfiguration jiraConfiguration) {
        this(LoggerFactory.getLogger(JiraIssueTracker.class), jiraConfiguration);
    }

    public ZephyrRestClient(Logger logger, JIRAConfiguration jiraConfiguration) {
        this.logger = logger;
        JIRAConnection jiraConnection = new JIRAConnection(jiraConfiguration);
        this.zapiUrl = jiraConnection.getJiraWebserviceUrl() + "rest/zapi/latest/";
        this.creds = jiraConnection.getJiraUser() + ":" + jiraConnection.getJiraPassword();
    }

    @Override
    public String getProjectKey(String projectName) throws IOException {
        JsonObject projectJsonObj = HttpClient.httpGetJSONObject(this.zapiUrl + "util/project-list", this.creds);
        if (null == projectJsonObj) {
            throw new IllegalStateException("JSONObject is null for getAllProjects");
        }
        JsonArray projectOptions = (JsonArray)projectJsonObj.get("options");
        for (int i = 0; i < projectOptions.size(); ++i) {
            JsonObject obj2 = projectOptions.get(i).getAsJsonObject();
            if (!obj2.get(ZAPI_LABEL).getAsString().equals(projectName)) continue;
            return obj2.get(ZAPI_VALUE).getAsString();
        }
        throw new IllegalStateException("Project " + projectName + " not found!!");
    }

    @Override
    public String getVersionID(String versionName, String projectId) throws IOException {
        JsonObject projectJsonObj = HttpClient.httpGetJSONObject(this.zapiUrl + "util/versionBoard-list?projectId=" + projectId, this.creds);
        if (null == projectJsonObj) {
            throw new IllegalStateException("JSONObject is null for versionName=" + versionName);
        }
        for (String object : new String[]{"unreleasedVersions", "releasedVersions"}) {
            JsonArray versionOptions = (JsonArray)projectJsonObj.get(object);
            for (int i = 0; i < versionOptions.size(); ++i) {
                JsonObject obj2 = versionOptions.get(i).getAsJsonObject();
                if (!obj2.get(ZAPI_LABEL).getAsString().equals(versionName)) continue;
                return obj2.get(ZAPI_VALUE).getAsString();
            }
        }
        throw new IllegalStateException("Version ID not found for versionName=" + versionName);
    }

    @Override
    public Map<String, ZephyrCycle> getListOfCycles(String projectId, String issueId, String versionId, String cycleId) throws IOException {
        JsonObject cyclesJsonObj;
        Gson gson = new Gson();
        String url = this.zapiUrl + "cycle?projectId=" + projectId;
        if (versionId != null) {
            url = url + "&versionId=" + versionId;
        }
        if (cycleId != null) {
            url = url + "&id=" + cycleId;
        }
        if (issueId != null) {
            url = url + "&issueId=" + issueId;
        }
        if (null == (cyclesJsonObj = HttpClient.httpGetJSONObject(url, this.creds))) {
            throw new IllegalStateException("JSONObject is null for issueId=" + issueId + " and versionId=" + versionId);
        }
        HashMap<String, ZephyrCycle> zephyrCycles = new HashMap<String, ZephyrCycle>();
        for (Map.Entry cycleIdentifier : cyclesJsonObj.entrySet()) {
            if ("recordsCount".equalsIgnoreCase((String)cycleIdentifier.getKey())) continue;
            zephyrCycles.put((String)cycleIdentifier.getKey(), (ZephyrCycle)gson.fromJson(cyclesJsonObj.get((String)cycleIdentifier.getKey()).getAsJsonObject().toString(), ZephyrCycle.class));
        }
        return zephyrCycles;
    }

    @Override
    public ZephyrCycle getCycle(String cycleId) throws IOException {
        Gson gson = new Gson();
        String url = this.zapiUrl + "cycle/" + cycleId;
        JsonObject cyclesJsonObj = HttpClient.httpGetJSONObject(url, this.creds);
        if (null == cyclesJsonObj) {
            throw new IllegalStateException("JSONObject is null for cycleId=" + cycleId);
        }
        return (ZephyrCycle)gson.fromJson(cyclesJsonObj.toString(), ZephyrCycle.class);
    }

    @Override
    public String createCycle(ZephyrCycle cycle) throws IOException {
        Gson gson = new Gson();
        this.logger.debug("Creating Cycle because none found: {}", (Object)cycle);
        String url = this.zapiUrl + "cycle";
        JsonObject response = HttpClient.post(url, this.creds, gson.toJson((Object)cycle));
        if (null == response) {
            throw new IllegalStateException("JSONObject is null for create cycle=" + cycle.toString());
        }
        return response.get("responseMessage").getAsString().contains("success") ? response.get("id").getAsString() : null;
    }

    @Override
    public boolean updateCycle(ZephyrCycle cycle) throws IOException {
        Gson gson = new Gson();
        String url = this.zapiUrl + "cycle";
        JsonObject response = HttpClient.put(url, this.creds, gson.toJson((Object)cycle));
        if (null == response) {
            throw new IllegalStateException("JSONObject is null for update cycle=" + cycle.toString());
        }
        return response.get("responseMessage").getAsString().contains("success");
    }

    @Override
    public Map<String, String> getIssueStatusIdsOfProject(String projectId) throws IOException {
        String url = this.zapiUrl + "zchart/issueStatuses?projectId=" + projectId;
        HashMap<String, String> issueStatus = new HashMap<String, String>();
        JsonObject issueStatusObj = HttpClient.httpGetJSONObject(url, this.creds);
        if (null == issueStatusObj) {
            throw new IllegalStateException("JSONObject is null for projectId=" + projectId);
        }
        JsonArray issueStatusOptions = (JsonArray)issueStatusObj.get("IssueStatusesOptionsList");
        for (int i = 0; i < issueStatusOptions.size(); ++i) {
            JsonObject obj2 = issueStatusOptions.get(i).getAsJsonObject();
            issueStatus.put(obj2.get(ZAPI_LABEL).getAsString(), obj2.get(ZAPI_VALUE).getAsString());
        }
        return issueStatus;
    }

    @Override
    public ZephyrExecutionDetails updateTestExecution(String executionId, ZephyrUpdater.Status status, String comment) throws IOException {
        Gson gson = new Gson();
        ZephyrExecutionDetails prevExec = this.getTestExecutionDetails(executionId);
        DateTime currentTime = new DateTime();
        ZephyrDateParser dateParser = new ZephyrDateParser(currentTime);
        if (prevExec.getExecutedOn() != null && currentTime.getMillis() - dateParser.parse(prevExec.getExecutedOn()).getMillis() < 1800000L && (!prevExec.getExecutionStatus().equals(String.valueOf(ZephyrUpdater.Status.PASS.getValue())) || prevExec.getExecutionStatus().equals(String.valueOf(status.getValue())))) {
            return null;
        }
        this.resetTestExecution(executionId);
        JsonObject obj = new JsonObject();
        obj.addProperty("status", String.valueOf(status.getValue()));
        obj.addProperty("comment", comment);
        return (ZephyrExecutionDetails)gson.fromJson(HttpClient.put(this.zapiUrl + "execution/" + executionId + "/execute", this.creds, obj).toString(), ZephyrExecutionDetails.class);
    }

    private void resetTestExecution(String executionId) throws IOException {
        Gson gson = new Gson();
        JsonObject obj = new JsonObject();
        obj.addProperty("status", String.valueOf(ZephyrUpdater.Status.UNEXECUTED.getValue()));
        obj.addProperty("comment", "RESET");
        gson.fromJson(HttpClient.put(this.zapiUrl + "execution/" + executionId + "/execute", this.creds, obj).toString(), ZephyrExecutionDetails.class);
    }

    @Override
    public ZephyrExecutionDetails getTestExecutionDetails(String executionId) throws IOException {
        Gson gson = new Gson();
        JsonObject testExecObj = HttpClient.httpGetJSONObject(this.zapiUrl + "execution/" + executionId, this.creds);
        return (ZephyrExecutionDetails)gson.fromJson(testExecObj.toString(), ZephyrExecutionDetails.class);
    }

    @Override
    public ZephyrExecutionDetails createTestExecution(String issueId, String projectId, String versionId, String cycleId, String assigneeType, String assignee) throws IOException {
        JsonObject response;
        Gson gson = new Gson();
        String url = this.zapiUrl + "execution";
        JsonObject obj = new JsonObject();
        obj.addProperty("cycleId", cycleId);
        obj.addProperty("issueId", issueId);
        obj.addProperty("projectId", projectId);
        obj.addProperty("versionId", versionId);
        if (assigneeType != null) {
            obj.addProperty("assigneeType", assigneeType);
        }
        if (assignee != null) {
            obj.addProperty("assignee", assigneeType);
        }
        if (null == (response = HttpClient.post(url, this.creds, obj))) {
            throw new IllegalStateException("JSONObject is null for create execution for issueId=" + issueId);
        }
        String key = (String)((Map.Entry)response.entrySet().iterator().next()).getKey();
        return (ZephyrExecutionDetails)gson.fromJson(response.get(key).toString(), ZephyrExecutionDetails.class);
    }

    @Override
    public List<ZephyrExecutionDetails> getListOfTestExecutions(String issueId, String projectId, String versionId, String cycleId) throws IOException {
        JsonObject executionsJsonObj;
        Gson gson = new Gson();
        String url = this.zapiUrl + "execution?issueId=" + issueId;
        if (projectId != null) {
            url = url + "&projectId=" + projectId;
        }
        if (versionId != null) {
            url = url + "&versionId=" + versionId;
        }
        if (cycleId != null) {
            url = url + "&cycleId=" + cycleId;
        }
        if (null == (executionsJsonObj = HttpClient.httpGetJSONObject(url, this.creds))) {
            throw new IllegalStateException("JSONObject is null for projectId=" + projectId + " and issueId=" + issueId);
        }
        ArrayList<ZephyrExecutionDetails> zephyrExecutions = new ArrayList<ZephyrExecutionDetails>();
        JsonArray executionsOptions = executionsJsonObj.get("executions").getAsJsonArray();
        for (int i = 0; i < executionsOptions.size(); ++i) {
            JsonObject obj2 = executionsOptions.get(i).getAsJsonObject();
            zephyrExecutions.add((ZephyrExecutionDetails)gson.fromJson(obj2.toString(), ZephyrExecutionDetails.class));
        }
        return zephyrExecutions;
    }

    @Override
    public JsonObject deleteTestExecution(List<String> executionIds) throws IOException {
        Gson gson = new Gson();
        JsonObject obj = new JsonObject();
        JsonElement jsonElement = gson.toJsonTree(executionIds);
        obj.add("executions", jsonElement);
        return HttpClient.delete(this.zapiUrl + "execution/deleteExecutions", this.creds, obj.toString());
    }
}

