/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.zephyr;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.service.JIRAConnection;
import net.serenitybdd.plugins.jira.zephyr.client.ZephyrClient;
import net.serenitybdd.plugins.jira.zephyr.domain.ZephyrCycle;
import net.serenitybdd.plugins.jira.zephyr.domain.ZephyrExecutionDetails;
import net.thucydides.core.model.TestOutcomeSummary;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZephyrUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZephyrUpdater.class);
    private static final String SKIP_JIRA_UPDATES = "serenity.skip.jira.updates";
    private static final String JIRA_MAX_THREADS = "jira.max.threads";
    public static final String IS_ZEPHYR_ACTIVE = "serenity.jira.zephyr.active";
    public static final String ZEPHYR_DEFAULT_CYCLE = "serenity.jira.zephyr.default.cycle";
    public static final String ZEPHYR_SELECTED_CYCLE = "serenity.jira.zephyr.update.selected.cycles";
    public static final String ZEPHYR_SELECTED_VERSION = "serenity.jira.zephyr.update.selected.versions";
    static final int DEFAULT_MAX_THREADS = 4;
    private final JIRAConnection jiraConnection;
    private final ListeningExecutorService executorService;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private EnvironmentVariables environmentVariables;
    private final String projectKey;
    private final ZephyrClient zephyrClient;
    private static final String DEFAULT_CYCLE = "FUNCTIONALITY";
    private static final String DEFAULT_COMMENT = "BY SERENITY";
    private String jiraURL;

    public ZephyrUpdater(IssueTracker issueTracker, EnvironmentVariables environmentVariables, ZephyrClient zephyrClient) {
        this.environmentVariables = environmentVariables;
        this.projectKey = environmentVariables.getProperty("jira.project");
        this.jiraConnection = issueTracker.getJiraConnection();
        this.zephyrClient = zephyrClient;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxJobs()));
        this.jiraURL = environmentVariables.getProperty("jira.url");
        this.logStatus();
    }

    private void logStatus() {
        LOGGER.debug("ZEPHYR ACTIVE: {} ", (Object)(this.shouldUpdateZephyr() && this.shouldUpdateZephyrExecution() ? 1 : 0));
    }

    public void updateZephyrExecutionStatus(Set<String> issues, final TestResultTally<TestOutcomeSummary> resultTally) {
        this.queueSize.set(issues.size());
        for (final String issue : issues) {
            ListenableFuture future = this.executorService.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return issue;
                }
            });
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    ZephyrUpdater.this.logZephyrExecutionTracking(issue);
                    if (!ZephyrUpdater.this.dryRun()) {
                        try {
                            ZephyrUpdater.this.updateZephyrExecution(issue, resultTally.getTestOutcomesForIssue(issue));
                        }
                        catch (IOException io) {
                            LOGGER.error("Failed to update Zephyr Status for Issue {}", (Object)issue);
                            LOGGER.error("exception occured while changing Zephyr execution status {}", (Throwable)io);
                        }
                        ZephyrUpdater.this.queueSize.decrementAndGet();
                    }
                }
            }, (Executor)MoreExecutors.newDirectExecutorService());
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    ZephyrUpdater.this.queueSize.decrementAndGet();
                }
            }, (Executor)this.executorService);
        }
        this.waitTillUpdatesDone(this.queueSize);
    }

    private void waitTillUpdatesDone(AtomicInteger counter) {
        while (counter.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateZephyrExecution(String issue, List<TestOutcomeSummary> testOutcomes) throws IOException {
        IssueSummary issueDetails = this.jiraConnection.getRestJiraClient().getIssue(issue);
        LOGGER.debug("Issue Type is: {}", (Object)issueDetails.getType());
        if ("Test".equalsIgnoreCase(issueDetails.getType()) && this.shouldUpdateZephyrExecution() && this.shouldUpdateZephyr()) {
            String issueId = String.valueOf(issueDetails.getId());
            String projectId = this.jiraConnection.getRestJiraClient().getProjectByKey(this.projectKey).getId();
            String versionId = this.returnSelectedVersionId(projectId);
            Status overallResult = this.returnExecutionStatus(testOutcomes);
            if (this.getZephyrSelectedTestCycleNames() == null) {
                this.updateExecutionsWithDefaultCycle(issueId, projectId, overallResult);
            } else {
                this.updateExecutionsWithSelectedCycle(issueId, projectId, versionId, overallResult);
            }
        }
    }

    private void updateExecutionsWithDefaultCycle(String issueId, String projectId, Status result) throws IOException {
        List<ZephyrExecutionDetails> execs = this.zephyrClient.getListOfTestExecutions(issueId, projectId, null, null);
        if (!execs.isEmpty()) {
            for (ZephyrExecutionDetails execution : execs) {
                this.zephyrClient.updateTestExecution(execution.getId(), result, DEFAULT_COMMENT);
            }
        } else {
            ArrayList<String> cycleIds = new ArrayList<String>();
            Map<String, ZephyrCycle> cycles = this.zephyrClient.getListOfCycles(projectId, issueId, null, null);
            for (Map.Entry<String, ZephyrCycle> cycle : cycles.entrySet()) {
                if (!cycles.get(cycle.getKey()).getName().equalsIgnoreCase(this.getZephyrDefaultTestCycleName())) continue;
                cycleIds.add(cycles.get(cycle.getKey()).getId());
            }
            if (cycleIds.isEmpty()) {
                ZephyrCycle cycle = new ZephyrCycle();
                cycle.setDescription("Serenity Functional Cycle!");
                cycle.setName(this.getZephyrDefaultTestCycleName());
                cycle.setProjectId(projectId);
                cycle.setVersionId("-1");
                cycleIds.add(this.zephyrClient.createCycle(cycle));
            }
            for (String cycleId : cycleIds) {
                ZephyrExecutionDetails execution = this.zephyrClient.createTestExecution(issueId, projectId, null, cycleId, null, null);
                this.zephyrClient.updateTestExecution(execution.getId(), result, DEFAULT_COMMENT);
            }
        }
    }

    private void updateExecutionsWithSelectedCycle(String issueId, String projectId, String versionId, Status result) throws IOException {
        List<ZephyrExecutionDetails> execs = this.zephyrClient.getListOfTestExecutions(issueId, projectId, versionId, null);
        for (ZephyrExecutionDetails execution : execs) {
            for (String cycleName : this.getZephyrSelectedTestCycleNames().split(",")) {
                if (!execution.getCycleName().equalsIgnoreCase(cycleName)) continue;
                this.zephyrClient.updateTestExecution(execution.getId(), result, DEFAULT_COMMENT);
            }
        }
    }

    private String returnSelectedVersionId(String projectId) throws IOException {
        String versionId = null;
        if (this.getZephyrSelectedTestCycleVersion() != null) {
            versionId = this.zephyrClient.getVersionID(this.getZephyrSelectedTestCycleVersion(), projectId);
        }
        return versionId;
    }

    private Status returnExecutionStatus(List<TestOutcomeSummary> testOutcomes) {
        TestResult overallResult = TestResultList.overallResultFrom((List)Lambda.convert(testOutcomes, this.toTestResults()));
        if (overallResult.equals((Object)TestResult.FAILURE) || overallResult.equals((Object)TestResult.ERROR) || overallResult.equals((Object)TestResult.COMPROMISED)) {
            return Status.FAIL;
        }
        if (overallResult.equals((Object)TestResult.PENDING)) {
            return Status.WIP;
        }
        if (overallResult.equals((Object)TestResult.IGNORED)) {
            return Status.PARTIALLY_PASS;
        }
        return Status.PASS;
    }

    private Converter<TestOutcomeSummary, TestResult> toTestResults() {
        return new Converter<TestOutcomeSummary, TestResult>(){

            public TestResult convert(TestOutcomeSummary from) {
                return from.getTestResult();
            }
        };
    }

    private void logZephyrExecutionTracking(String issueId) {
        if (this.dryRun()) {
            LOGGER.info("--- DRY RUN ONLY: ZEPHYR WILL NOT BE UPDATED ---");
        }
        LOGGER.info("Updating Zypher Execution: {}", (Object)issueId);
    }

    private boolean dryRun() {
        return Boolean.valueOf(this.environmentVariables.getProperty(SKIP_JIRA_UPDATES));
    }

    private int getMaxJobs() {
        return this.environmentVariables.getPropertyAsInteger(JIRA_MAX_THREADS, Integer.valueOf(4));
    }

    private boolean shouldUpdateZephyr() {
        return !StringUtils.isEmpty((CharSequence)this.jiraURL);
    }

    public boolean shouldUpdateZephyrExecution() {
        return this.environmentVariables.getPropertyAsBoolean(IS_ZEPHYR_ACTIVE, false);
    }

    protected String getZephyrSelectedTestCycleVersion() {
        return this.environmentVariables.getProperty(ZEPHYR_SELECTED_VERSION, null);
    }

    protected String getZephyrDefaultTestCycleName() {
        return this.environmentVariables.getProperty(ZEPHYR_DEFAULT_CYCLE, DEFAULT_CYCLE);
    }

    protected String getZephyrSelectedTestCycleNames() {
        return this.environmentVariables.getProperty(ZEPHYR_SELECTED_CYCLE, null);
    }

    public static enum Status {
        UNEXECUTED(-1),
        PASS(1),
        FAIL(2),
        WIP(3),
        BLOCKED(4),
        PARTIALLY_PASS(5);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

