/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.zephyr;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ZephyrDateParser {
    private final DateTime today;
    private final DateTime yesterday;
    private final DateTime sunday;
    private final DateTime wednesday;
    private final DateTime saturday;
    private final DateTime friday;
    private final DateTime thursday;

    public ZephyrDateParser(DateTime today) {
        this.today = today;
        this.yesterday = today.minusDays(1);
        this.sunday = today.withDayOfWeek(7);
        this.wednesday = today.withDayOfWeek(3);
        this.saturday = today.withDayOfWeek(6);
        this.friday = today.withDayOfWeek(5);
        this.thursday = today.withDayOfWeek(4);
    }

    public DateTime parse(String date) {
        if (date.contains("Today")) {
            date = date.replace("Today", this.today.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Yesterday")) {
            date = date.replace("Yesterday", this.yesterday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Sunday")) {
            date = date.replace("Sunday", this.sunday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Wednesday")) {
            date = date.replace("Wednesday", this.wednesday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Saturday")) {
            date = date.replace("Saturday", this.saturday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Friday")) {
            date = date.replace("Friday", this.friday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        } else if (date.contains("Thursday")) {
            date = date.replace("Thursday", this.thursday.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        }
        for (int daysBack = 2; daysBack < 7; ++daysBack) {
            DateTime aPreviousDay = this.today.minusDays(daysBack);
            String day = aPreviousDay.dayOfWeek().getAsText();
            if (!date.contains(day)) continue;
            date = date.replace(day, aPreviousDay.toString(DateTimeFormat.forPattern((String)"d/MMM/yy")));
        }
        return DateTime.parse((String)date, (DateTimeFormatter)DateTimeFormat.forPattern((String)"d/MMM/yy hh:mm a"));
    }
}

