/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.serenitybdd.plugins.jira.model.NamedTestResult;
import net.serenitybdd.plugins.jira.model.TestResultComment;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;

public class JIRACommentBuilder {
    public static final String SERENITY_COMMENT_HEADING = "Serenity BDD Automated Acceptance Tests";
    private final boolean wikiRendering;
    private final String testRunNumber;
    private final String reportUrl;
    private final LocalDateTime executionTime;
    private final List<NamedTestResult> namedTestResults;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public JIRACommentBuilder(boolean wikiRendering) {
        this(wikiRendering, null);
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl) {
        this(wikiRendering, reportUrl, null, null, LocalDateTime.now());
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl, List<NamedTestResult> testOutcomes) {
        this(wikiRendering, reportUrl, testOutcomes, null, LocalDateTime.now());
    }

    public JIRACommentBuilder(boolean wikiRendering, List<NamedTestResult> testOutcomes, String reportUrl, String testRunNumber) {
        this(wikiRendering, reportUrl, testOutcomes, testRunNumber, LocalDateTime.now());
    }

    private static List<NamedTestResult> namedTestResultsFrom(List<TestOutcome> testOutcomes) {
        return Lambda.convert(testOutcomes, JIRACommentBuilder.toNamedTestResults());
    }

    private static Converter<TestOutcome, NamedTestResult> toNamedTestResults() {
        return new Converter<TestOutcome, NamedTestResult>(){

            public NamedTestResult convert(TestOutcome from) {
                return new NamedTestResult(from.getTitle(), from.getResult());
            }
        };
    }

    public JIRACommentBuilder(boolean wikiRendering, String reportUrl, List<NamedTestResult> namedTestResults, String testRunNumber, LocalDateTime executionTime) {
        this.reportUrl = reportUrl;
        this.namedTestResults = namedTestResults;
        this.testRunNumber = testRunNumber;
        this.wikiRendering = wikiRendering;
        this.executionTime = executionTime;
    }

    public String asText() {
        StringBuilder commentBuilder = new StringBuilder();
        this.addLine(commentBuilder, this.bold(SERENITY_COMMENT_HEADING));
        String executionTimestamp = "Tests run: " + this.executionTime.format(DateTimeFormatter.ofPattern("d MMM yyyy hh:mm a"));
        if (this.wikiRendering) {
            this.addLine(commentBuilder, executionTimestamp + " - [full report|" + this.reportUrl + "]");
        } else {
            this.addLine(commentBuilder, executionTimestamp + " - full report: " + this.reportUrl);
        }
        if (this.testRunNumber != null) {
            this.addLine(commentBuilder, "Test Run: " + this.testRunNumber);
        }
        this.addLineForEachTest(commentBuilder);
        return commentBuilder.toString();
    }

    private String bold(String text) {
        return this.wikiRendering ? "*" + text + "*" : text;
    }

    private void addLineForEachTest(StringBuilder commentBuilder) {
        if (this.namedTestResults != null) {
            for (NamedTestResult testResult : this.namedTestResults) {
                this.addLine(commentBuilder, "  - " + testResult.getTestName() + ": " + testResult.getTestResult() + " " + this.resultIconFor(testResult.getTestResult()));
            }
        }
    }

    private String resultIconFor(TestResult testResult) {
        if (!this.wikiRendering) {
            return "";
        }
        switch (testResult) {
            case SUCCESS: {
                return ": (/)";
            }
            case FAILURE: {
                return ": (x)";
            }
            case ERROR: {
                return ": (x)";
            }
            case PENDING: {
                return ": (!)";
            }
            case SKIPPED: {
                return ": (!)";
            }
            case IGNORED: {
                return ": (!)";
            }
        }
        return ": (?)";
    }

    private void addLine(StringBuilder commentBuilder, String line) {
        commentBuilder.append(line).append(NEW_LINE);
    }

    public JIRACommentBuilder withResults(List<NamedTestResult> testOutcomes) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, testOutcomes);
    }

    public JIRACommentBuilder withTestRun(String testRunNumber) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, this.namedTestResults, testRunNumber, this.executionTime);
    }

    public JIRACommentBuilder withReportUrl(String reportUrl) {
        return new JIRACommentBuilder(this.wikiRendering, reportUrl, this.namedTestResults, this.testRunNumber, this.executionTime);
    }

    public JIRACommentBuilder withNamedResults(List<NamedTestResult> namedTestResults) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, namedTestResults, this.testRunNumber, this.executionTime);
    }

    public JIRACommentBuilder forTestsExecutedAt(LocalDateTime executionTime) {
        return new JIRACommentBuilder(this.wikiRendering, this.reportUrl, this.namedTestResults, this.testRunNumber, executionTime);
    }

    public TestResultComment asComment() {
        return new TestResultComment(this.reportUrl, this.testRunNumber, this.namedTestResults, this.wikiRendering, this.executionTime);
    }
}

