/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.serenitybdd.plugins.jira.JiraUpdater;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.guice.Injectors;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.workflow.WorkflowLoader;
import net.serenitybdd.plugins.jira.zephyr.ZephyrUpdater;
import net.serenitybdd.plugins.jira.zephyr.client.ZephyrClient;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestOutcomeSummary;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraStepListener
implements StepListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraStepListener.class);
    private static TestResultTally<TestOutcomeSummary> resultTally = new TestResultTally();
    private static Set<String> testSuiteIssues = new CopyOnWriteArraySet<String>();
    private JiraUpdater jiraUpdater;
    private ZephyrUpdater zypherUpdater;

    @Inject
    public JiraStepListener(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader, ZephyrClient zephyrClient) {
        this.jiraUpdater = new JiraUpdater(issueTracker, environmentVariables, loader);
        this.zypherUpdater = new ZephyrUpdater(issueTracker, environmentVariables, zephyrClient);
    }

    public JiraStepListener() {
        this((IssueTracker)Injectors.getInjector().getInstance(IssueTracker.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), (WorkflowLoader)Injectors.getInjector().getInstance(WorkflowLoader.class), (ZephyrClient)Injectors.getInjector().getInstance(ZephyrClient.class));
    }

    public void testSuiteStarted(Class<?> testCase) {
        testSuiteIssues.clear();
    }

    public void testSuiteStarted(Story story) {
        testSuiteIssues.clear();
    }

    public void testStarted(String testName) {
    }

    public void testStarted(String description, String id) {
    }

    public void testFinished(TestOutcome result) {
        if (this.jiraUpdater.shouldUpdateIssues() || this.zypherUpdater.shouldUpdateZephyrExecution()) {
            List<String> issues = this.jiraUpdater.getPrefixedIssuesWithoutHashes(new TestOutcomeSummary(result));
            this.tallyResults(new TestOutcomeSummary(result), issues);
            testSuiteIssues.addAll(issues);
        }
    }

    private void tallyResults(TestOutcomeSummary result, List<String> issues) {
        for (String issue : issues) {
            resultTally.recordResult(issue, result);
        }
    }

    public void testSuiteFinished() {
        if (this.jiraUpdater.shouldUpdateIssues()) {
            this.jiraUpdater.updateIssueStatus(testSuiteIssues, resultTally);
        }
        if (this.zypherUpdater.shouldUpdateZephyrExecution()) {
            this.zypherUpdater.updateZephyrExecutionStatus(testSuiteIssues, resultTally);
        }
    }

    public void testRetried() {
    }

    public void stepStarted(ExecutedStepDescription executedStepDescription) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure stepFailure) {
    }

    public void lastStepFailed(StepFailure stepFailure) {
    }

    public void stepIgnored() {
    }

    public void stepIgnored(String s) {
    }

    public void stepPending() {
    }

    public void stepPending(String s) {
    }

    public void assumptionViolated(String s) {
    }

    public void testRunFinished() {
    }

    public void stepFinished() {
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void testIsManual() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable dataTable) {
    }

    public void addNewExamplesFrom(DataTable dataTable) {
    }

    public void exampleStarted(Map<String, String> stringStringMap) {
    }

    public void exampleStarted() {
    }

    public void exampleFinished() {
    }

    public TestResultTally getTestResultTally() {
        return resultTally;
    }

    public Set<String> getTestSuiteIssues() {
        return testSuiteIssues;
    }

    public JiraUpdater getJiraUpdater() {
        return this.jiraUpdater;
    }
}

