/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.serenitybdd.plugins.jira.JiraUpdater;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.guice.Injectors;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.workflow.WorkflowLoader;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestOutcomeSummary;
import net.thucydides.core.reports.JiraUpdaterService;
import net.thucydides.core.reports.TestOutcomeStream;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraFileServiceUpdater
implements JiraUpdaterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraFileServiceUpdater.class);
    private final TestResultTally<TestOutcomeSummary> resultTally = new TestResultTally();
    private Set<String> allIssues = new HashSet<String>();
    private JiraUpdater jiraUpdater;

    @Inject
    public JiraFileServiceUpdater(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader) {
        this.jiraUpdater = new JiraUpdater(issueTracker, environmentVariables, loader);
    }

    public JiraFileServiceUpdater() {
        this((IssueTracker)Injectors.getInjector().getInstance(IssueTracker.class), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), (WorkflowLoader)Injectors.getInjector().getInstance(WorkflowLoader.class));
    }

    public List<TestOutcomeSummary> updateJiraForTestResultsFrom(String outcomeDirectory) throws IOException {
        LOGGER.info("Update Jira for test results from " + outcomeDirectory);
        List<TestOutcomeSummary> testOutcomeSummaries = JiraFileServiceUpdater.loadTestOutcomesSummariesFromPath(outcomeDirectory);
        for (TestOutcomeSummary currentTestOutcomeSummary : testOutcomeSummaries) {
            this.loadTestOutcomeSummary(currentTestOutcomeSummary);
        }
        this.updateAllIssuesStatus();
        return testOutcomeSummaries;
    }

    public List<TestOutcomeSummary> updateJiraForTestResultsFrom(String outcomeDirectory, String outcomesNameFilter) throws IOException {
        List<TestOutcomeSummary> testOutcomeSummaries = JiraFileServiceUpdater.loadTestOutcomesSummariesFromPath(outcomeDirectory);
        for (TestOutcomeSummary currentTestOutcomeSummary : testOutcomeSummaries) {
            if (!currentTestOutcomeSummary.getName().matches(outcomesNameFilter)) continue;
            this.loadTestOutcomeSummary(currentTestOutcomeSummary);
        }
        this.updateAllIssuesStatus();
        return testOutcomeSummaries;
    }

    private static List<TestOutcomeSummary> loadTestOutcomesSummariesFromPath(String outcomesPath) throws IOException {
        ArrayList testOutcomes = Lists.newArrayList();
        Path directory = Paths.get(outcomesPath, new String[0]);
        try (TestOutcomeStream stream = TestOutcomeStream.testOutcomesInDirectory((Path)directory);){
            for (TestOutcome outcome : stream) {
                testOutcomes.add(new TestOutcomeSummary(outcome, directory));
            }
        }
        return testOutcomes;
    }

    private void loadTestOutcomeSummary(TestOutcomeSummary outcomeSummary) {
        if (this.jiraUpdater.shouldUpdateIssues()) {
            List<String> issues = this.jiraUpdater.getPrefixedIssuesWithoutHashes(outcomeSummary);
            this.tallyResults(outcomeSummary, issues);
            this.allIssues.addAll(issues);
        }
    }

    private void updateAllIssuesStatus() {
        if (this.jiraUpdater.shouldUpdateIssues()) {
            this.jiraUpdater.updateIssueStatus(this.allIssues, this.resultTally);
        }
    }

    private void tallyResults(TestOutcomeSummary result, List<String> issues) {
        for (String issue : issues) {
            this.resultTally.recordResult(issue, result);
        }
    }

    public JiraUpdater getJiraUpdater() {
        return this.jiraUpdater;
    }
}

