/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;

public class LegacySafariDriverProvider
implements DriverProvider {
    private final DriverCapabilityRecord driverProperties;
    private final FixtureProviderService fixtureProviderService;

    public LegacySafariDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        SafariOptions safariOptions = SafariOptions.fromCapabilities((Capabilities)enhancer.enhanced((MutableCapabilities)new DesiredCapabilities(), SupportedWebDriver.SAFARI));
        if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forSafari();
        }
        SafariDriver driver = new SafariDriver(safariOptions);
        this.driverProperties.registerCapabilities("safari", this.capabilitiesToProperties(driver.getCapabilities()));
        return driver;
    }
}

