/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.webdriver.driverproviders.AddLoggingPreferences;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ProvideNewDriver;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.serenitybdd.core.webdriver.driverproviders.webdrivermanager.WebDriverManagerSetup;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.GeckoServicePool;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyFirefoxDriverProvider
implements DriverProvider {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DriverCapabilityRecord driverProperties;
    private final DriverServicePool driverServicePool = new GeckoServicePool();
    private final FixtureProviderService fixtureProviderService;

    protected String serviceName() {
        return "firefox";
    }

    public LegacyFirefoxDriverProvider(FixtureProviderService fixtureProviderService) {
        this.fixtureProviderService = fixtureProviderService;
        this.driverProperties = (DriverCapabilityRecord)WebDriverInjectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options, EnvironmentVariables environmentVariables) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        if (this.isDriverAutomaticallyDownloaded(environmentVariables)) {
            this.logger.info("Using automatically driver download");
            WebDriverManagerSetup.usingEnvironmentVariables(environmentVariables).forFirefox();
        } else {
            this.logger.info("Not using automatically driver download");
        }
        CapabilityEnhancer enhancer = new CapabilityEnhancer(environmentVariables, this.fixtureProviderService);
        new FirefoxDriverCapabilities(environmentVariables, options).getOptions();
        FirefoxOptions firefoxOptions = new FirefoxDriverCapabilities(environmentVariables, options).getOptions();
        SetProxyConfiguration.from(environmentVariables).in((MutableCapabilities)firefoxOptions);
        AddLoggingPreferences.from(environmentVariables).to((MutableCapabilities)firefoxOptions);
        enhancer.enhanced((MutableCapabilities)firefoxOptions, SupportedWebDriver.FIREFOX);
        this.driverProperties.registerCapabilities("firefox", this.capabilitiesToProperties((Capabilities)firefoxOptions));
        return ProvideNewDriver.withConfiguration(environmentVariables, (Capabilities)firefoxOptions, this.driverServicePool, DriverServicePool::newDriver, (pool, caps) -> new FirefoxDriver(firefoxOptions));
    }
}

