/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.annotations.DefaultUrl;
import net.thucydides.core.annotations.NamedUrl;
import net.thucydides.core.annotations.NamedUrls;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;

public class PageUrls {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final String NAMED_URL_PREFIX = "page:";
    private static final int CLASSPATH_URL_PREFIX_LENGTH = "classpath:".length();
    private Object pageObject;
    private String pageLevelDefaultBaseUrl;
    private final Configuration configuration;

    public PageUrls(Object pageObject, Configuration configuration) {
        this.pageObject = pageObject;
        this.configuration = configuration;
    }

    public PageUrls(Object pageObject) {
        this(pageObject, ConfiguredEnvironment.getConfiguration());
    }

    public PageUrls(Object pageObject, EnvironmentVariables environmentVariables) {
        this(pageObject, ConfiguredEnvironment.getConfiguration().withEnvironmentVariables(environmentVariables));
    }

    public String getStartingUrl() {
        Optional<String> declaredDefaultUrl = this.getDeclaredDefaultUrl();
        String url = declaredDefaultUrl.isPresent() ? this.addBaseUrlTo(declaredDefaultUrl.get()) : this.getBaseUrl();
        return this.verified(url, this.pageObject);
    }

    public Optional<String> getDeclaredDefaultUrl() {
        DefaultUrl urlAnnotation = this.pageObject.getClass().getAnnotation(DefaultUrl.class);
        if (urlAnnotation != null) {
            return Optional.ofNullable(urlAnnotation.value());
        }
        return Optional.ofNullable(this.pageLevelDefaultBaseUrl);
    }

    public String verified(String requestedUrl, Object pageObject) {
        if (PageUrls.isAClasspathResource(requestedUrl)) {
            return PageUrls.obtainResourcePathFromClasspath(requestedUrl).toString();
        }
        try {
            URL url = new URL(requestedUrl);
            return url.toString();
        }
        catch (MalformedURLException e) {
            if (requestedUrl == null) {
                throw new AssertionError((Object)("Undefined default URL for page object " + pageObject.getClass().getSuperclass().getSimpleName()));
            }
            throw new AssertionError((Object)("Invalid URL: " + requestedUrl));
        }
    }

    public static String getUrlFrom(String annotatedBaseUrl) {
        if (annotatedBaseUrl == null) {
            return null;
        }
        if (PageUrls.isAClasspathResource(annotatedBaseUrl)) {
            URL baseUrl = PageUrls.obtainResourcePathFromClasspath(annotatedBaseUrl);
            return baseUrl.toString();
        }
        if (PageUrls.isANamedUrl(annotatedBaseUrl)) {
            return PageUrls.namedUrlFrom(annotatedBaseUrl);
        }
        return annotatedBaseUrl;
    }

    private static boolean isANamedUrl(String annotatedBaseUrl) {
        return annotatedBaseUrl.startsWith(NAMED_URL_PREFIX);
    }

    private static boolean isAClasspathResource(String annotatedBaseUrl) {
        return annotatedBaseUrl != null && annotatedBaseUrl.startsWith(CLASSPATH_URL_PREFIX);
    }

    private static URL obtainResourcePathFromClasspath(String classpathUrl) {
        String resourcePath = classpathUrl.substring(CLASSPATH_URL_PREFIX_LENGTH);
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
        if (resourceUrl == null) {
            throw new IllegalStateException("No matching web page could be found on the classpath for " + classpathUrl);
        }
        return resourceUrl;
    }

    private static String namedUrlFrom(String annotatedBaseUrl) {
        String pageName = annotatedBaseUrl.substring(NAMED_URL_PREFIX.length());
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        return EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{pageName}).orElse(environmentVariables.getProperty(pageName));
    }

    private String getBaseUrl() {
        String baseUrl = StringUtils.isNotEmpty((CharSequence)this.getSystemBaseUrl()) ? this.getSystemBaseUrl() : this.pageLevelDefaultBaseUrl;
        return PageUrls.getUrlFrom(baseUrl);
    }

    public String getStartingUrl(String ... parameterValues) {
        String startingUrlTemplate = this.getStartingUrl();
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    public String getNamedUrl(String name) {
        NamedUrls urlAnnotation = this.pageObject.getClass().getAnnotation(NamedUrls.class);
        if (urlAnnotation != null) {
            NamedUrl[] namedUrlList;
            for (NamedUrl namedUrl : namedUrlList = urlAnnotation.value()) {
                if (!namedUrl.name().equals(name)) continue;
                return this.prefixedWithDefaultUrl(namedUrl.url());
            }
        }
        throw new IllegalArgumentException("No URL named " + name + " was found in this class");
    }

    private String prefixedWithDefaultUrl(String url) {
        Optional<String> optionalDeclaredDefaultUrl = this.getDeclaredDefaultUrl();
        if (optionalDeclaredDefaultUrl.isPresent() && this.isARelativeUrl(url)) {
            String declaredDefaultUrl = optionalDeclaredDefaultUrl.get();
            if (PageUrls.isANamedUrl(declaredDefaultUrl)) {
                declaredDefaultUrl = PageUrls.namedUrlFrom(declaredDefaultUrl);
            }
            return StringUtils.stripEnd((String)declaredDefaultUrl, (String)"/") + "/" + StringUtils.stripStart((String)url, (String)"/");
        }
        return url;
    }

    public String getNamedUrl(String name, String[] parameterValues) {
        String startingUrlTemplate = this.getNamedUrl(name);
        return this.urlWithParametersSubstituted(startingUrlTemplate, parameterValues);
    }

    private String urlWithParametersSubstituted(String template, String[] parameterValues) {
        String url = this.addBaseUrlTo(template);
        for (int i = 0; i < parameterValues.length; ++i) {
            String variable = String.format("{%d}", i + 1);
            url = url.replace(variable, parameterValues[i]);
        }
        return url;
    }

    public String addDefaultUrlTo(String url) {
        return this.prefixedWithDefaultUrl(url);
    }

    public String addBaseUrlTo(String url) {
        if (url != null && this.getBaseUrl() != null && url.startsWith(this.getBaseUrl())) {
            return url;
        }
        if (PageUrls.isANamedUrl(url)) {
            return PageUrls.namedUrlFrom(url);
        }
        if (PageUrls.isAClasspathResource(url) && this.baseUrlIsDefined()) {
            return this.getBaseUrl();
        }
        if (this.isARelativeUrl(url)) {
            return this.updatedRelativeUrl(url);
        }
        return this.updatedFullUrl(url);
    }

    private boolean baseUrlIsDefined() {
        return StringUtils.isNotEmpty((CharSequence)this.getBaseUrl());
    }

    private String updatedFullUrl(String url) {
        if (PageUrls.isAClasspathResource(url)) {
            return url;
        }
        String updatedUrl = url;
        if (StringUtils.isNotEmpty((CharSequence)this.getBaseUrl())) {
            try {
                updatedUrl = this.removeDoubleSlashesFrom(this.getBaseUrl() + this.pathFrom(url));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)("Invalid URL: " + url));
            }
        }
        return updatedUrl;
    }

    private String removeDoubleSlashesFrom(String url) {
        return url.replaceAll("([^:])//", "$1/");
    }

    private String pathFrom(String url) throws MalformedURLException {
        URL defaultUrl = new URL(url);
        return url.substring(url.indexOf(defaultUrl.getAuthority()) + defaultUrl.getAuthority().length());
    }

    private String updatedRelativeUrl(String url) {
        String updatedUrl = StringUtils.isNotEmpty((CharSequence)this.getBaseUrl()) ? this.getBaseUrl() + url : url;
        return updatedUrl;
    }

    private boolean isARelativeUrl(String url) {
        return url.startsWith("/");
    }

    public void overrideDefaultBaseUrl(String defaultBaseUrl) {
        this.pageLevelDefaultBaseUrl = defaultBaseUrl;
    }

    public String getSystemBaseUrl() {
        return this.configuration.getBaseUrl();
    }
}

