/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.core.IgnoredStepException;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Reportable;
import net.serenitybdd.core.SessionMap;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.configurers.WebDriverConfigurer;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.injectors.EnvironmentDependencyInjector;
import net.serenitybdd.core.lifecycle.LifecycleRegister;
import net.serenitybdd.core.reports.ReportDataSaver;
import net.serenitybdd.core.reports.WithTitle;
import net.serenitybdd.core.sessions.TestSessionVariables;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxProfile;

public class Serenity {
    private static final ThreadLocal<WebDriverFactory> factoryThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepListener> stepListenerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<TestSessionVariables> testSessionThreadLocal = new ThreadLocal();
    private static final ThreadLocal<FirefoxProfile> firefoxProfileThreadLocal = new ThreadLocal();
    private static boolean throwExceptionsImmediately = false;

    public static void initialize(Object testCase) {
        ThucydidesWebDriverSupport.initialize();
        Serenity.setupWebDriverFactory();
        Serenity.setupWebdriverManager();
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.initStepListener();
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        Serenity.injectDependenciesInto(testCase);
    }

    private static void injectDependenciesInto(Object testCase) {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.injectDependenciesInto(testCase);
        }
    }

    private static void resetDependencyInjectors() {
        for (DependencyInjector dependencyInjector : Serenity.getDependencyInjectors()) {
            dependencyInjector.reset();
        }
    }

    private static List<DependencyInjector> getDependencyInjectors() {
        List dependencyInjectors = Serenity.getDependencyInjectorService().findDependencyInjectors();
        dependencyInjectors.addAll(Serenity.getDefaultDependencyInjectors());
        return dependencyInjectors;
    }

    private static DependencyInjectorService getDependencyInjectorService() {
        return (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    private static List<DependencyInjector> getDefaultDependencyInjectors() {
        return Arrays.asList(new PageObjectDependencyInjector(Serenity.getPages()), new EnvironmentDependencyInjector());
    }

    public static SerenityConfigurer initializeWithNoStepListener(Object testCase) {
        Serenity.setupWebDriverFactory();
        Serenity.setupWebdriverManager();
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.initializeFieldsIn(testCase);
        Serenity.injectDriverInto(testCase);
        Serenity.injectAnnotatedPagesObjectInto(testCase);
        Serenity.injectScenarioStepsInto(testCase);
        Serenity.injectDependenciesInto(testCase);
        return new SerenityConfigurer();
    }

    public static void initStepListener() {
        Configuration configuration = ConfiguredEnvironment.getConfiguration();
        File outputDirectory = configuration.getOutputDirectory();
        BaseStepListener listener = new BaseStepListener(outputDirectory, Serenity.getPages());
        stepListenerThreadLocal.set(listener);
        StepEventBus.getEventBus().registerListener(Serenity.getStepListener());
    }

    private static void setupWebDriverFactory() {
        factoryThreadLocal.set((WebDriverFactory)WebDriverInjectors.getInjector().getInstance(WebDriverFactory.class));
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(ThucydidesWebDriverSupport.getDriver(), ThucydidesWebDriverSupport.getWebdriverManager());
    }

    public static void injectScenarioStepsInto(Object testCase) {
        StepAnnotations.injector().injectScenarioStepsInto(testCase, Serenity.getStepFactory());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injector().injectOptionalAnnotatedPagesObjectInto(testCase, Serenity.getPages());
    }

    public static void done() {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        boolean restartBrowserIfNecessary = !RestartBrowserForEach.configuredIn(environmentVariables).restartBrowserForANew(RestartBrowserForEach.NEVER);
        Serenity.done(restartBrowserIfNecessary);
    }

    public static boolean currentDriverIsDisabled() {
        WebDriver currentDriver = Serenity.getWebdriverManager().getCurrentDriver();
        return currentDriver != null && currentDriver instanceof WebDriverFacade && ((WebDriverFacade)currentDriver).isDisabled();
    }

    public static void done(boolean closeAllDrivers) {
        if (closeAllDrivers && Serenity.getWebdriverManager() != null) {
            Serenity.getWebdriverManager().closeAllDrivers();
        }
        Serenity.notifyTestFinished();
        Serenity.resetDependencyInjectors();
        LifecycleRegister.clear();
    }

    private static void notifyTestFinished() {
        for (StepListener listener : Serenity.stepListeners()) {
            listener.testRunFinished();
        }
    }

    public static String getCurrentSessionID() {
        if (Serenity.getWebdriverManager() != null && Serenity.getWebdriverManager().getSessionId() != null) {
            return Serenity.getWebdriverManager().getSessionId().toString();
        }
        return null;
    }

    public static WebDriver getDriver() {
        return Serenity.getWebdriverManager().getWebdriver();
    }

    protected static Pages getPages() {
        return ThucydidesWebDriverSupport.getPages();
    }

    protected static void stopUsingMockDriver() {
        Serenity.setupWebdriverManager();
    }

    public static WebdriverManager getWebdriverManager() {
        return ThucydidesWebDriverSupport.getWebdriverManager();
    }

    public static StepFactory getStepFactory() {
        return ThucydidesWebDriverSupport.getStepFactory();
    }

    private static void setupWebdriverManager() {
        Serenity.setupWebdriverManager(ThucydidesWebDriverSupport.getWebdriverManager());
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager) {
        ThucydidesWebDriverSupport.initialize(webdriverManager, "");
    }

    private static List<StepListener> stepListeners() {
        if (Serenity.getStepListener() == null) {
            return new ArrayList<StepListener>();
        }
        return NewList.of((Object[])new StepListener[]{Serenity.getStepListener()});
    }

    public static StepListener getStepListener() {
        return stepListenerThreadLocal.get();
    }

    public static void initializeTestSession() {
        Serenity.getCurrentSession().clear();
    }

    public static SessionMap<Object, Object> getCurrentSession() {
        if (testSessionThreadLocal.get() == null) {
            testSessionThreadLocal.set(new TestSessionVariables());
        }
        return testSessionThreadLocal.get();
    }

    public static void pendingStep(String reason) {
        throw new PendingStepException(reason);
    }

    public static void ignoredStep(String reason) {
        throw new IgnoredStepException(reason);
    }

    public static void takeScreenshot() {
        StepEventBus.getEventBus().takeScreenshot();
    }

    public static WithTitle recordReportData() {
        return new ReportDataSaver(StepEventBus.getEventBus());
    }

    public static String getDefaultProjectKey() {
        String workingDirPath = System.getProperty("user.dir");
        return new File(workingDirPath).getName();
    }

    public static void useFirefoxProfile(FirefoxProfile profile) {
        firefoxProfileThreadLocal.set(profile);
    }

    public static FirefoxProfile getFirefoxProfile() {
        return firefoxProfileThreadLocal.get();
    }

    public static boolean hasASessionVariableCalled(Object key) {
        return Serenity.getCurrentSession().containsKey(key);
    }

    public static <T> T sessionVariableCalled(Object key) {
        return (T)Serenity.getCurrentSession().get(key);
    }

    public static SessionVariableSetter setSessionVariable(Object key) {
        return new SessionVariableSetter(key);
    }

    public static void clearSessionVariable(String key) {
        Serenity.getCurrentSession().remove(key);
    }

    public static void clearCurrentSession() {
        Serenity.getCurrentSession().clear();
    }

    public static Pages getPagesFactory() {
        return null;
    }

    public static void throwExceptionsImmediately() {
        throwExceptionsImmediately = true;
    }

    public static boolean shouldThrowErrorsImmediately() {
        return throwExceptionsImmediately;
    }

    public static WebDriverConfigurer webdriver() {
        return new WebDriverConfigurer();
    }

    public static void reportThat(String message, Reportable reportableAction) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)message));
        try {
            reportableAction.perform();
            StepEventBus.getEventBus().stepFinished();
        }
        catch (Throwable assertionFailed) {
            StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)message), assertionFailed));
        }
    }

    public static class SerenityConfigurer {
        public SerenityConfigurer throwExceptionsImmediately() {
            Serenity.throwExceptionsImmediately();
            return this;
        }
    }

    public static class SessionVariableSetter {
        final Object key;

        public SessionVariableSetter(Object key) {
            this.key = key;
        }

        public <T> void to(T value) {
            if (value != null) {
                Serenity.getCurrentSession().put(this.key, value);
            } else {
                Serenity.getCurrentSession().remove(this.key);
            }
        }
    }
}

