/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.css.CssFormatter;
import net.revelc.code.formatter.html.HTMLFormatter;
import net.revelc.code.formatter.xml.XMLFormatter;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;

public abstract class AbstractCacheableFormatter {
    protected Log log;
    protected Charset encoding;

    protected abstract void init(Map<String, String> var1, ConfigurationSource var2);

    protected void initCfg(ConfigurationSource cfg) {
        this.log = cfg.getLog();
        this.encoding = cfg.getEncoding();
    }

    public String formatFile(File file, String originalCode, LineEnding ending) {
        try {
            String formattedCode;
            this.log.debug((CharSequence)("Processing file: " + file + " with line ending: " + ending));
            LineEnding formatterLineEnding = ending;
            if (formatterLineEnding == LineEnding.KEEP) {
                formatterLineEnding = LineEnding.determineLineEnding(originalCode);
                this.log.debug((CharSequence)("Determined line ending: " + formatterLineEnding + " to keep for file: " + file));
            }
            if ((formattedCode = this.doFormat(originalCode, formatterLineEnding)) == null) {
                this.log.debug((CharSequence)"Nothing formatted. Try to fix line endings.");
                formattedCode = AbstractCacheableFormatter.fixLineEnding(originalCode, ending);
            } else if (this instanceof CssFormatter || this instanceof HTMLFormatter || this instanceof XMLFormatter) {
                this.log.debug((CharSequence)"Formatted but line endings not supported by tooling. Try to fix line endings.");
                formattedCode = AbstractCacheableFormatter.fixLineEnding(formattedCode, ending);
            }
            if (formattedCode == null) {
                this.log.debug((CharSequence)"Equal code. Not writing result to file.");
                return originalCode;
            }
            this.log.debug((CharSequence)"Line endings fixed");
            return formattedCode;
        }
        catch (IOException | BadLocationException | MalformedTreeException e) {
            this.log.warn(e);
            return null;
        }
    }

    private static String fixLineEnding(String code, LineEnding ending) {
        if (ending == LineEnding.KEEP) {
            return null;
        }
        code = code.replace(LineEnding.CRLF.getChars(), LineEnding.LF.getChars());
        code = code.replace(LineEnding.CR.getChars(), LineEnding.LF.getChars());
        return code.replace(LineEnding.LF.getChars(), ending.getChars());
    }

    protected abstract String doFormat(String var1, LineEnding var2) throws IOException, BadLocationException;
}

