/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.greenhopper;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.greenhopper.EstimateSum;
import net.rcarz.jiraclient.greenhopper.GreenHopperField;
import net.rcarz.jiraclient.greenhopper.RapidView;
import net.rcarz.jiraclient.greenhopper.Sprint;
import net.rcarz.jiraclient.greenhopper.SprintIssue;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SprintReport {
    private RestClient restclient = null;
    private Sprint sprint = null;
    private List<SprintIssue> completedIssues = null;
    private List<SprintIssue> incompletedIssues = null;
    private List<SprintIssue> puntedIssues = null;
    private EstimateSum completedIssuesEstimateSum = null;
    private EstimateSum incompletedIssuesEstimateSum = null;
    private EstimateSum allIssuesEstimateSum = null;
    private EstimateSum puntedIssuesEstimateSum = null;
    private List<String> issueKeysAddedDuringSprint = null;

    protected SprintReport(RestClient restclient, JSONObject json) {
        this.restclient = restclient;
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.sprint = GreenHopperField.getResource(Sprint.class, map.get("sprint"), this.restclient);
        this.completedIssues = GreenHopperField.getResourceArray(SprintIssue.class, map.get("completedIssues"), this.restclient);
        this.incompletedIssues = GreenHopperField.getResourceArray(SprintIssue.class, map.get("incompletedIssues"), this.restclient);
        this.puntedIssues = GreenHopperField.getResourceArray(SprintIssue.class, map.get("puntedIssues"), this.restclient);
        this.completedIssuesEstimateSum = GreenHopperField.getEstimateSum(map.get("completedIssuesEstimateSum"));
        this.incompletedIssuesEstimateSum = GreenHopperField.getEstimateSum(map.get("incompletedIssuesEstimateSum"));
        this.allIssuesEstimateSum = GreenHopperField.getEstimateSum(map.get("allIssuesEstimateSum"));
        this.puntedIssuesEstimateSum = GreenHopperField.getEstimateSum(map.get("puntedIssuesEstimateSum"));
        this.issueKeysAddedDuringSprint = GreenHopperField.getStringArray(map.get("issueKeysAddedDuringSprint"));
    }

    public static SprintReport get(RestClient restclient, RapidView rv, Sprint sprint) throws JiraException {
        final int rvId = rv.getId();
        final int sprintId = sprint.getId();
        JSON result = null;
        try {
            URI reporturi = restclient.buildURI("/rest/greenhopper/1.0/rapid/charts/sprintreport", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("rapidViewId", Integer.toString(rvId));
                    this.put("sprintId", Integer.toString(sprintId));
                }
            });
            result = restclient.get(reporturi);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve sprint report", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (!jo.containsKey((Object)"contents") || !(jo.get("contents") instanceof JSONObject)) {
            throw new JiraException("Sprint report content is malformed");
        }
        return new SprintReport(restclient, (JSONObject)jo.get("contents"));
    }

    public Sprint getSprint() {
        return this.sprint;
    }

    public List<SprintIssue> getCompletedIssues() {
        return this.completedIssues;
    }

    public List<SprintIssue> getIncompletedIssues() {
        return this.incompletedIssues;
    }

    public List<SprintIssue> getPuntedIssues() {
        return this.puntedIssues;
    }

    public EstimateSum getCompletedIssuesEstimateSum() {
        return this.completedIssuesEstimateSum;
    }

    public EstimateSum getIncompletedIssuesEstimateSum() {
        return this.incompletedIssuesEstimateSum;
    }

    public EstimateSum getAllIssuesEstimateSum() {
        return this.allIssuesEstimateSum;
    }

    public EstimateSum getPuntedIssuesEstimateSum() {
        return this.puntedIssuesEstimateSum;
    }

    public List<String> getIssueKeysAddedDuringSprint() {
        return this.issueKeysAddedDuringSprint;
    }
}

