/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.greenhopper;

import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.greenhopper.Backlog;
import net.rcarz.jiraclient.greenhopper.GreenHopperField;
import net.rcarz.jiraclient.greenhopper.GreenHopperResource;
import net.rcarz.jiraclient.greenhopper.Sprint;
import net.rcarz.jiraclient.greenhopper.SprintReport;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapidView
extends GreenHopperResource {
    private String name = null;
    private boolean canEdit = false;
    private boolean sprintSupportEnabled = false;

    protected RapidView(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.id = Field.getInteger(map.get("id"));
        this.name = Field.getString(map.get("name"));
        this.canEdit = Field.getBoolean(map.get("canEdit"));
        this.sprintSupportEnabled = Field.getBoolean(map.get("sprintSupportEnabled"));
    }

    public static RapidView get(RestClient restclient, int id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/greenhopper/1.0/rapidview/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve rapid view " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new RapidView(restclient, (JSONObject)result);
    }

    public static List<RapidView> getAll(RestClient restclient) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get("/rest/greenhopper/1.0/rapidview");
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve rapid views", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (!jo.containsKey((Object)"views") || !(jo.get("views") instanceof JSONArray)) {
            throw new JiraException("Rapid View result is malformed");
        }
        return GreenHopperField.getResourceArray(RapidView.class, jo.get("views"), restclient);
    }

    public List<Sprint> getSprints() throws JiraException {
        JSON result = null;
        try {
            result = this.restclient.get("/rest/greenhopper/1.0/sprintquery/" + this.id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve sprints", ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)result;
        if (!jo.containsKey((Object)"sprints") || !(jo.get("sprints") instanceof JSONArray)) {
            throw new JiraException("Sprints result is malformed");
        }
        return GreenHopperField.getResourceArray(Sprint.class, jo.get("sprints"), this.restclient);
    }

    public SprintReport getSprintReport(Sprint sprint) throws JiraException {
        return SprintReport.get(this.restclient, this, sprint);
    }

    public Backlog getBacklogData() throws JiraException {
        return Backlog.get(this.restclient, this);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Boolean canEdit() {
        return this.canEdit;
    }

    public Boolean isSprintSupportEnabled() {
        return this.sprintSupportEnabled;
    }
}

