/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Project;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class Version
extends Resource {
    private String name = null;
    private boolean archived = false;
    private boolean released = false;
    private String releaseDate;
    private String description = null;

    protected Version(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    public void mergeWith(Version version) {
        JSONObject req = new JSONObject();
        req.put((Object)"description", (Object)version.getDescription());
        req.put((Object)"name", (Object)version.getName());
        req.put((Object)"archived", (Object)version.isArchived());
        req.put((Object)"released", (Object)version.isReleased());
        req.put((Object)"releaseDate", (Object)version.getReleaseDate());
        try {
            this.restclient.put(Resource.getBaseUri() + "version/" + this.id, (JSON)req);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to merge", ex);
        }
    }

    public void copyTo(Project project) {
        JSONObject req = new JSONObject();
        req.put((Object)"description", (Object)this.getDescription());
        req.put((Object)"name", (Object)this.getName());
        req.put((Object)"archived", (Object)this.isArchived());
        req.put((Object)"released", (Object)this.isReleased());
        req.put((Object)"releaseDate", (Object)this.getReleaseDate());
        req.put((Object)"project", (Object)project.getKey());
        req.put((Object)"projectId", (Object)project.getId());
        try {
            this.restclient.post(Resource.getBaseUri() + "version/", (JSON)req);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to copy to project '" + project.getKey() + "'", ex);
        }
    }

    public static Version get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(Version.getBaseUri() + "version/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve version " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new Version(restclient, (JSONObject)result);
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.name = Field.getString(map.get("name"));
        this.archived = Field.getBoolean(map.get("archived"));
        this.released = Field.getBoolean(map.get("released"));
        this.releaseDate = Field.getString(map.get("releaseDate"));
        this.description = Field.getString(map.get("description"));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isReleased() {
        return this.released;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getDescription() {
        return this.description;
    }
}

