/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.stage.data.bytes;

import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.impl.VanillaChronicleHashHolder;
import net.openhft.chronicle.hash.impl.stage.entry.HashEntryStages;
import net.openhft.chronicle.hash.impl.stage.entry.SegmentStages;
import net.openhft.chronicle.hash.impl.stage.hash.CheckOnEachPublicOperation;
import net.openhft.chronicle.hash.impl.stage.hash.KeyBytesInterop;
import net.openhft.chronicle.hash.serialization.impl.IntegerDataAccess;
import net.openhft.chronicle.hash.serialization.impl.WrongXxHash;
import net.openhft.sg.Stage;
import net.openhft.sg.StageRef;
import net.openhft.sg.Staged;

@Staged
public class EntryKeyBytesData<K>
extends AbstractData<K> {
    @StageRef
    VanillaChronicleHashHolder<K> hh;
    @StageRef
    KeyBytesInterop<K> ki;
    @StageRef
    SegmentStages s;
    @StageRef
    HashEntryStages<K> entry;
    @StageRef
    CheckOnEachPublicOperation checkOnEachPublicOperation;
    @Stage(value="CachedEntryKey")
    private K cachedEntryKey;
    @Stage(value="CachedEntryKey")
    private boolean cachedEntryKeyRead = false;

    private void initCachedEntryKey() {
        this.cachedEntryKey = this.innerGetUsing(this.cachedEntryKey);
        this.cachedEntryKeyRead = true;
    }

    @Override
    public RandomDataInput bytes() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.s.segmentBS;
    }

    @Override
    public long offset() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entry.keyOffset;
    }

    @Override
    public long size() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.entry.keySize;
    }

    @Override
    public long hash(LongHashFunction f) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        if (f == LongHashFunction.xx_r39() && this.entry.keySize == 4L && this.hh.h().keyDataAccess instanceof IntegerDataAccess) {
            return WrongXxHash.hashInt(this.s.segmentBS.readInt(this.entry.keyOffset));
        }
        return super.hash(f);
    }

    @Override
    public K get() {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.cachedEntryKey;
    }

    @Override
    public K getUsing(K using) {
        this.checkOnEachPublicOperation.checkOnEachPublicOperation();
        return this.innerGetUsing(using);
    }

    private K innerGetUsing(K usingKey) {
        Bytes bytes = this.s.segmentBytesForRead();
        bytes.readPosition(this.entry.keyOffset);
        return this.ki.keyReader.read(bytes, this.size(), usingKey);
    }
}

