/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser$;
import net.liftweb.json.JsonParser$Buffer$;
import net.liftweb.json.JsonParser$CloseArr$;
import net.liftweb.json.JsonParser$CloseObj$;
import net.liftweb.json.JsonParser$End$;
import net.liftweb.json.JsonParser$NullVal$;
import net.liftweb.json.JsonParser$OpenArr$;
import net.liftweb.json.JsonParser$OpenObj$;
import net.liftweb.json.JsonParser$Parser$ARRAY$;
import net.liftweb.json.JsonParser$Parser$OBJECT$;
import net.liftweb.json.JsonParser$Segments$;
import scala.BigInt;
import scala.BigInt$;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.Tuple3;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonParser {
    public static final String unquote(Buffer buffer) {
        return JsonParser$.MODULE$.unquote(buffer);
    }

    public static final String unquote(String string) {
        return JsonParser$.MODULE$.unquote(string);
    }

    public static final <A> A parse(Reader reader, Function1<Parser, A> function1) {
        return JsonParser$.MODULE$.parse(reader, function1);
    }

    public static final <A> A parse(String string, Function1<Parser, A> function1) {
        return JsonParser$.MODULE$.parse(string, function1);
    }

    public static final Option<JsonAST.JValue> parseOpt(Reader reader) {
        return JsonParser$.MODULE$.parseOpt(reader);
    }

    public static final Option<JsonAST.JValue> parseOpt(String string) {
        return JsonParser$.MODULE$.parseOpt(string);
    }

    public static final JsonAST.JValue parse(Reader reader) {
        return JsonParser$.MODULE$.parse(reader);
    }

    public static final JsonAST.JValue parse(String string) {
        return JsonParser$.MODULE$.parse(string);
    }

    public static final int $tag() throws RemoteException {
        return JsonParser$.MODULE$.$tag();
    }

    public static abstract class Token
    implements ScalaObject {
        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class Buffer
    implements ScalaObject {
        private int curSegmentIdx;
        private int cur;
        private char[] segment;
        private List<Segment> segments;
        private int curMarkSegment;
        private int curMark;
        private int length;
        private final Reader in;

        public Buffer(Reader in) {
            this.in = in;
            this.length = -1;
            this.curMark = -1;
            this.curMarkSegment = -1;
            this.segments = Nil$.MODULE$;
            this.cur = 0;
            this.curSegmentIdx = 0;
            this.read();
        }

        private void read() {
            try {
                Segment newSegment = JsonParser$Segments$.MODULE$.apply();
                this.length_$eq(this.in.read(newSegment.seg()));
                this.segment = newSegment.seg();
                List<Segment> list = this.segments;
                this.segments = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Segment[]{newSegment})).$colon$colon$colon(list);
                this.cur = 0;
                this.curSegmentIdx = this.segments.length() - 1;
                return;
            }
            finally {
                if (this.length() < this.segment.length) {
                    this.in.close();
                }
            }
        }

        public void release() {
            this.segments.foreach((Function1)new Buffer$$anonfun$release$1(this));
        }

        public String near() {
            return new String(this.segment, Predef$.MODULE$.intWrapper(this.cur - 20).max(0), Predef$.MODULE$.intWrapper(this.cur + 20).min(this.length()));
        }

        public String substring() {
            String string;
            if (this.curSegmentIdx == this.curMarkSegment()) {
                string = new String(this.segment, this.curMark(), this.cur - this.curMark() - 1);
            } else {
                int i;
                Nil$ parts = Nil$.MODULE$;
                for (i = this.curSegmentIdx; i >= this.curMarkSegment(); --i) {
                    char[] s = ((Segment)this.segments.apply(i)).seg();
                    int start = i == this.curMarkSegment() ? this.curMark() : 0;
                    int end = i == this.curSegmentIdx ? this.cur : s.length + 1;
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)end), (Object)s);
                    parts = parts.$colon$colon((Object)tuple3);
                }
                int len = BoxesRunTime.unboxToInt((Object)parts.map((Function1)new Buffer$$anonfun$2(this)).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Buffer$$anonfun$3(this)));
                char[] chars = new char[len];
                int pos = 0;
                for (i = 0; i < parts.size(); ++i) {
                    Tuple3 tuple3 = (Tuple3)parts.apply(i);
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                    int start = BoxesRunTime.unboxToInt((Object)tuple32._1());
                    int end = BoxesRunTime.unboxToInt((Object)tuple32._2());
                    char[] b = (char[])(tuple32._3() instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)tuple32._3(), Character.TYPE) : tuple32._3());
                    int partLen = end - start - 1;
                    System.arraycopy(b, start, chars, pos, partLen);
                    pos += partLen;
                }
                string = new String(chars);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public char next() {
            void var1_1;
            char exceptionResult6 = '\u0000';
            try {
                void var3_2;
                char c = this.segment[this.cur];
                if (this.cur >= this.length()) {
                    return JsonParser$.MODULE$.net$liftweb$json$JsonParser$$EOF();
                }
                ++this.cur;
                exceptionResult6 = var3_2;
            }
            catch (Throwable throwable) {
                this.read();
                exceptionResult6 = this.length() == -1 ? JsonParser$.MODULE$.net$liftweb$json$JsonParser$$EOF() : this.next();
            }
            return (char)var1_1;
        }

        public void back() {
            --this.cur;
        }

        public void mark() {
            this.curMark_$eq(this.cur);
            this.curMarkSegment_$eq(this.curSegmentIdx);
        }

        public void curMarkSegment_$eq(int x$1) {
            this.curMarkSegment = x$1;
        }

        public int curMarkSegment() {
            return this.curMarkSegment;
        }

        public void curMark_$eq(int x$1) {
            this.curMark = x$1;
        }

        public int curMark() {
            return this.curMark;
        }

        public void length_$eq(int x$1) {
            this.length = x$1;
        }

        public int length() {
            return this.length;
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class Parser
    implements ScalaObject {
        private /* synthetic */ JsonParser$Parser$OBJECT$ OBJECT$module;
        private /* synthetic */ JsonParser$Parser$ARRAY$ ARRAY$module;
        private boolean fieldNameMode;
        private final LinkedList<BlockMode> blocks;
        private final Buffer buf;

        public Parser(Buffer buf) {
            this.buf = buf;
            this.blocks = new LinkedList();
            this.fieldNameMode = true;
        }

        private final /* synthetic */ boolean gd8$1(char x$1) {
            return this.isDelimiter$1(x$1);
        }

        private final /* synthetic */ boolean gd7$1(char x$1) {
            return Character.isDigit(x$1) || x$1 == '-';
        }

        private final /* synthetic */ boolean gd6$1(char x$1) {
            return JsonParser$.MODULE$.net$liftweb$json$JsonParser$$EOF() == x$1;
        }

        private final Product parseValue$1(char first) {
            boolean wasInt = true;
            boolean doubleVal = false;
            StringBuilder s = new StringBuilder();
            s.append(first);
            while (wasInt) {
                StringBuilder stringBuilder;
                char c = this.buf.next();
                if (c == '.' || c == 'e' || c == 'E') {
                    doubleVal = true;
                    stringBuilder = s.append(c);
                    continue;
                }
                if (Character.isDigit(c) || c == '.' || c == 'e' || c == 'E' || c == '-') {
                    stringBuilder = s.append(c);
                    continue;
                }
                wasInt = false;
                this.buf.back();
                stringBuilder = BoxedUnit.UNIT;
            }
            String value = s.toString();
            return doubleVal ? new DoubleVal(Predef$.MODULE$.stringWrapper(value).toDouble()) : new IntVal(BigInt$.MODULE$.apply(value));
        }

        private final String parseString$1() {
            String exceptionResult5 = null;
            try {
                exceptionResult5 = JsonParser$.MODULE$.unquote(this.buf);
                return exceptionResult5;
            }
            catch (Throwable throwable) {
                throw this.fail("unexpected string end");
            }
        }

        private final String parseFieldName$1() {
            this.buf.mark();
            char c = this.buf.next();
            while (c != JsonParser$.MODULE$.net$liftweb$json$JsonParser$$EOF()) {
                if (c == '\"') {
                    return this.buf.substring();
                }
                c = this.buf.next();
            }
            throw this.fail("expected string end");
        }

        private final boolean isDelimiter$1(char c) {
            return c == ' ' || c == '\n' || c == ',' || c == '\r' || c == '\t' || c == '}' || c == ']';
        }

        public final JsonParser$Parser$OBJECT$ OBJECT() {
            if (this.OBJECT$module == null) {
                this.OBJECT$module = new JsonParser$Parser$OBJECT$(this);
            }
            return this.OBJECT$module;
        }

        public final JsonParser$Parser$ARRAY$ ARRAY() {
            if (this.ARRAY$module == null) {
                this.ARRAY$module = new JsonParser$Parser$ARRAY$(this);
            }
            return this.ARRAY$module;
        }

        public Token nextToken() {
            char c;
            while (true) {
                char c2;
                if (this.gd6$1(c2 = (c = this.buf.next()))) {
                    return JsonParser$End$.MODULE$;
                }
                if (c == '{') {
                    this.blocks.addFirst(this.OBJECT());
                    this.fieldNameMode = true;
                    return JsonParser$OpenObj$.MODULE$;
                }
                if (c == '}') {
                    this.blocks.poll();
                    return JsonParser$CloseObj$.MODULE$;
                }
                if (c == '\"') {
                    if (this.fieldNameMode && BoxesRunTime.equals((Object)this.blocks.peek(), (Object)this.OBJECT())) {
                        return new FieldStart(this.parseFieldName$1());
                    }
                    this.fieldNameMode = true;
                    return new StringVal(this.parseString$1());
                }
                if (c == 't') {
                    this.fieldNameMode = true;
                    if (this.buf.next() == 'r' && this.buf.next() == 'u' && this.buf.next() == 'e') {
                        return new BoolVal(true);
                    }
                    throw this.fail("expected boolean");
                }
                if (c == 'f') {
                    this.fieldNameMode = true;
                    if (this.buf.next() == 'a' && this.buf.next() == 'l' && this.buf.next() == 's' && this.buf.next() == 'e') {
                        return new BoolVal(false);
                    }
                    throw this.fail("expected boolean");
                }
                if (c == 'n') {
                    this.fieldNameMode = true;
                    if (this.buf.next() == 'u' && this.buf.next() == 'l' && this.buf.next() == 'l') {
                        return JsonParser$NullVal$.MODULE$;
                    }
                    throw this.fail("expected null");
                }
                if (c == ':') {
                    this.fieldNameMode = false;
                    continue;
                }
                if (c == '[') {
                    this.blocks.addFirst(this.ARRAY());
                    return JsonParser$OpenArr$.MODULE$;
                }
                if (c == ']') {
                    this.fieldNameMode = true;
                    this.blocks.poll();
                    return JsonParser$CloseArr$.MODULE$;
                }
                char c3 = c;
                if (this.gd7$1(c3)) {
                    this.fieldNameMode = true;
                    return (Token)this.parseValue$1(c);
                }
                if (!this.gd8$1(c)) break;
            }
            throw this.fail(new StringBuilder().append((Object)"unknown token ").append((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
        }

        public Nothing$ fail(String msg) {
            throw new ParseException(new StringBuilder().append((Object)msg).append((Object)"\nNear: ").append((Object)this.buf.near()).toString(), null);
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }

        public abstract class BlockMode
        implements ScalaObject {
            public BlockMode() {
                if (Parser.this == null) {
                    throw new NullPointerException();
                }
            }

            public /* synthetic */ Parser net$liftweb$json$JsonParser$Parser$BlockMode$$$outer() {
                return Parser.this;
            }

            public int $tag() throws RemoteException {
                return ScalaObject.class.$tag((ScalaObject)this);
            }
        }
    }

    public static class IntVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final BigInt value;

        public IntVal(BigInt value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd3$1(BigInt x$1) {
            BigInt bigInt = x$1;
            BigInt bigInt2 = this.value();
            return !(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "IntVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof IntVal && this.gd3$1(((IntVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -1040423063;
        }

        public BigInt value() {
            return this.value;
        }
    }

    public static interface Segment {
        public char[] seg();
    }

    public static class BoolVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final boolean value;

        public BoolVal(boolean value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd5$1(boolean x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToBoolean((boolean)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BoolVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof BoolVal && this.gd5$1(((BoolVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 213721088;
        }

        public boolean value() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValStack
    implements ScalaObject {
        private final LinkedList<JsonAST.JValue> stack;
        private final Parser parser;

        public ValStack(Parser parser) {
            this.parser = parser;
            this.stack = new LinkedList();
        }

        public Option<JsonAST.JValue> peekOption() {
            return this.stack.isEmpty() ? None$.MODULE$ : new Some((Object)this.stack.peek());
        }

        private <A extends JsonAST.JValue> A convert(JsonAST.JValue x, Class<A> expectedType) {
            JsonAST.JValue jValue = x;
            if (jValue == null || jValue.equals(null)) {
                throw this.parser.fail("expected object or array");
            }
            JsonAST.JValue exceptionResult4 = null;
            try {
                exceptionResult4 = x;
            }
            catch (ClassCastException classCastException) {
                throw this.parser.fail(new StringBuilder().append((Object)"unexpected ").append((Object)x).toString());
            }
            return (A)exceptionResult4;
        }

        public <A extends JsonAST.JValue> JsonAST.JValue replace(JsonAST.JValue newTop) {
            return this.stack.set(0, newTop);
        }

        public <A extends JsonAST.JValue> A peek(Class<A> expectedType) {
            return this.convert(this.stack.peek(), expectedType);
        }

        public void push(JsonAST.JValue v) {
            this.stack.addFirst(v);
        }

        public <A extends JsonAST.JValue> A pop(Class<A> expectedType) {
            return this.convert(this.stack.poll(), expectedType);
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class DoubleVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final double value;

        public DoubleVal(double value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd4$1(double x$1) {
            return x$1 == this.value();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return BoxesRunTime.boxToDouble((double)this.value());
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DoubleVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof DoubleVal && this.gd4$1(((DoubleVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 671775609;
        }

        public double value() {
            return this.value;
        }
    }

    public static class StringVal
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final String value;

        public StringVal(String value) {
            this.value = value;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd2$1(String x$1) {
            String string = x$1;
            String string2 = this.value();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.value();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringVal";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof StringVal && this.gd2$1(((StringVal)object).value()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 1288646457;
        }

        public String value() {
            return this.value;
        }
    }

    public static class FieldStart
    extends Token
    implements ScalaObject,
    Product,
    Serializable {
        private final String name;

        public FieldStart(String name) {
            this.name = name;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd1$1(String x$1) {
            String string = x$1;
            String string2 = this.name();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.name();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FieldStart";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof FieldStart && this.gd1$1(((FieldStart)object).name()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -862849345;
        }

        public String name() {
            return this.name;
        }
    }

    public static class ParseException
    extends Exception
    implements ScalaObject {
        public ParseException(String message, Exception cause) {
            super(message, cause);
        }

        public int $tag() throws RemoteException {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }

    public static class RecycledSegment
    implements Segment,
    ScalaObject,
    Product,
    Serializable {
        private final char[] seg;

        public RecycledSegment(char[] seg) {
            this.seg = seg;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd9$1(char[] x$1) {
            return x$1 == this.seg();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.seg();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RecycledSegment";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof RecycledSegment && this.gd9$1(((RecycledSegment)object).seg()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return -62676757;
        }

        public char[] seg() {
            return this.seg;
        }
    }

    public static class DisposableSegment
    implements Segment,
    ScalaObject,
    Product,
    Serializable {
        private final char[] seg;

        public DisposableSegment(char[] seg) {
            this.seg = seg;
            Product.class.$init$((Product)this);
        }

        private final /* synthetic */ boolean gd10$1(char[] x$1) {
            return x$1 == this.seg();
        }

        public Object productElement(int x$1) {
            int n = x$1;
            if (n == 0) {
                return this.seg();
            }
            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DisposableSegment";
        }

        public boolean equals(Object x$1) {
            Object object;
            return x$1 instanceof Object && (this == x$1 || (object = x$1) instanceof DisposableSegment && this.gd10$1(((DisposableSegment)object).seg()));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public int $tag() {
            return 919083676;
        }

        public char[] seg() {
            return this.seg;
        }
    }
}

