/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.cache;

import java.util.HashMap;
import java.util.Map;
import net.kut3.cache.Cache;
import net.kut3.cache.CacheClientBuilder;
import net.kut3.cache.CacheClientFactory;
import net.kut3.cache.CacheType;

public enum CacheClientManager {
    INSTANCE;

    private final Map<String, Cache> cacheClients = new HashMap<String, Cache>();
    private final Map<CacheType, CacheClientFactory> factoryInstances = new HashMap<CacheType, CacheClientFactory>();

    private CacheClientManager() {
        try {
            this.factoryInstances.put(CacheType.REDIS, (CacheClientFactory)Class.forName("net.kut3.cache.redis.CacheClientFactory").newInstance());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.cacheClients.forEach((k, c) -> c.close())));
    }

    public static Cache getByName(String name) {
        return INSTANCE.get(name);
    }

    public static CacheClientBuilder newBuilder(CacheType cacheType) {
        return new CacheClientBuilder(cacheType);
    }

    Cache get(String cacheName) {
        return this.cacheClients.get(cacheName);
    }

    CacheClientFactory getFactory(CacheType cacheType) {
        return this.factoryInstances.get((Object)cacheType);
    }

    synchronized void register(String name, Cache source) {
        if (this.cacheClients.containsKey(name)) {
            throw new IllegalArgumentException("Cache system name '" + name + "' already registered");
        }
        this.cacheClients.put(name, source);
    }

    synchronized void register(CacheType cacheType, Class<? extends CacheClientFactory> clazz) throws ReflectiveOperationException {
        this.factoryInstances.put(cacheType, clazz.newInstance());
    }
}

