/*
 * Decompiled with CFR 0.152.
 */
package net.kut3.cache;

import net.kut3.cache.Cache;
import net.kut3.cache.CacheClientManager;
import net.kut3.cache.CacheMode;
import net.kut3.cache.CacheType;
import net.kut3.cache.InitializationException;

public final class CacheClientBuilder {
    private final CacheType cacheType;
    private String name;
    private String servers;
    private String user;
    private char[] pwd;
    private CacheMode mode = CacheMode.CLUSTER;
    private int connectionTimeout = 5000;
    private boolean enableConnectionsPool = true;
    private boolean isReused = true;

    CacheClientBuilder(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    public String servers() {
        return this.servers;
    }

    public CacheClientBuilder servers(String servers) {
        this.servers = servers;
        return this;
    }

    public CacheMode mode() {
        return this.mode;
    }

    public CacheClientBuilder mode(CacheMode cacheMode) {
        this.mode = cacheMode;
        return this;
    }

    public String user() {
        return this.user;
    }

    public CacheClientBuilder user(String user) {
        this.user = user;
        return this;
    }

    public char[] pwd() {
        return this.pwd;
    }

    public CacheClientBuilder pwd(char[] pwd) {
        this.pwd = pwd;
        return this;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public CacheClientBuilder connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public String name() {
        return this.name;
    }

    public CacheClientBuilder name(String name) {
        this.name = name;
        return this;
    }

    public boolean enableConnectionsPool() {
        return this.enableConnectionsPool;
    }

    public CacheClientBuilder enableConnectionsPool(boolean enableConnectionsPool) {
        this.enableConnectionsPool = enableConnectionsPool;
        return this;
    }

    public boolean isReused() {
        return this.isReused;
    }

    public CacheClientBuilder isReused(boolean isReused) {
        this.isReused = isReused;
        return this;
    }

    public Cache build() throws InitializationException {
        Cache cache;
        if (this.isReused && null == this.name) {
            throw new IllegalArgumentException("Cache name is required in case of isReused is equals true");
        }
        if (null != this.name && null != (cache = CacheClientManager.INSTANCE.get(this.name))) {
            return cache;
        }
        cache = CacheClientManager.INSTANCE.getFactory(this.cacheType).get(this);
        if (this.isReused) {
            CacheClientManager.INSTANCE.register(this.name, cache);
        }
        return cache;
    }
}

