/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.jsign.DigestAlgorithm;
import net.jsign.PrivateKeyUtils;

public class OracleCloudCredentials {
    private String user;
    private String tenancy;
    private String region;
    private String keyfile;
    private String fingerprint;
    private String passphrase;
    private PrivateKey privateKey;

    public String getUser() {
        return this.user;
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public String getRegion() {
        return this.region;
    }

    public String getKeyfile() {
        return this.keyfile;
    }

    public String getFingerprint() {
        if (this.fingerprint == null) {
            try {
                this.fingerprint = this.getFingerprint(this.getPrivateKey());
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Unable to compute the OCI API key fingerprint", e);
            }
        }
        return this.fingerprint;
    }

    String getFingerprint(PrivateKey privateKey) throws GeneralSecurityException {
        RSAPrivateCrtKey key = (RSAPrivateCrtKey)privateKey;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent());
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(publicKeySpec);
        byte[] digest = DigestAlgorithm.MD5.getMessageDigest().digest(publicKey.getEncoded());
        return IntStream.range(0, digest.length).mapToObj(i -> String.format("%02x", digest[i])).collect(Collectors.joining(":"));
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getKeyId() {
        return this.getTenancy() + "/" + this.getUser() + "/" + this.getFingerprint();
    }

    PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            try {
                this.privateKey = PrivateKeyUtils.load(new File(this.getKeyfile()), this.getPassphrase());
            }
            catch (KeyException e) {
                throw new RuntimeException("Unable to load the private key", e);
            }
        }
        return this.privateKey;
    }

    public void load(File file, String profile) throws IOException {
        if (file == null) {
            file = OracleCloudCredentials.getConfigFile();
        }
        if (profile == null) {
            profile = OracleCloudCredentials.getDefaultProfile();
        }
        Properties properties = new Properties();
        boolean profileFound = false;
        for (String line : Files.readAllLines(file.toPath())) {
            String[] elements;
            if (profileFound && line.startsWith("[")) break;
            if (line.equals("[" + profile + "]")) {
                profileFound = true;
                continue;
            }
            if (!profileFound || (elements = line.split("=", 2)).length != 2) continue;
            properties.setProperty(elements[0].trim(), elements[1].trim());
        }
        if (!profileFound) {
            throw new IOException("Profile '" + profile + "' not found in " + file);
        }
        this.user = properties.getProperty("user");
        this.tenancy = properties.getProperty("tenancy");
        this.region = properties.getProperty("region");
        this.keyfile = properties.getProperty("key_file");
        this.fingerprint = properties.getProperty("fingerprint");
        this.passphrase = properties.getProperty("pass_phrase");
    }

    public void loadFromEnvironment() {
        if (OracleCloudCredentials.getenv("OCI_CLI_USER") != null) {
            this.user = OracleCloudCredentials.getenv("OCI_CLI_USER");
        }
        if (OracleCloudCredentials.getenv("OCI_CLI_TENANCY") != null) {
            this.tenancy = OracleCloudCredentials.getenv("OCI_CLI_TENANCY");
        }
        if (OracleCloudCredentials.getenv("OCI_CLI_REGION") != null) {
            this.region = OracleCloudCredentials.getenv("OCI_CLI_REGION");
        }
        if (OracleCloudCredentials.getenv("OCI_CLI_KEY_FILE") != null) {
            this.keyfile = OracleCloudCredentials.getenv("OCI_CLI_KEY_FILE");
        }
        if (OracleCloudCredentials.getenv("OCI_CLI_FINGERPRINT") != null) {
            this.fingerprint = OracleCloudCredentials.getenv("OCI_CLI_FINGERPRINT");
        }
        if (OracleCloudCredentials.getenv("OCI_CLI_PASS_PHRASE") != null) {
            this.passphrase = OracleCloudCredentials.getenv("OCI_CLI_PASS_PHRASE");
        }
    }

    public static OracleCloudCredentials getDefault() throws IOException {
        OracleCloudCredentials credentials = new OracleCloudCredentials();
        File config = OracleCloudCredentials.getConfigFile();
        if (config.exists()) {
            credentials.load(config, OracleCloudCredentials.getDefaultProfile());
        }
        credentials.loadFromEnvironment();
        return credentials;
    }

    public static String getDefaultProfile() {
        String profile = OracleCloudCredentials.getenv("OCI_CLI_PROFILE");
        if (profile == null) {
            profile = "DEFAULT";
        }
        return profile;
    }

    public static File getConfigFile() {
        String config = OracleCloudCredentials.getenv("OCI_CLI_CONFIG_FILE");
        if (config != null) {
            return new File(config);
        }
        return new File(System.getProperty("user.home"), ".oci/config");
    }

    static String getenv(String name) {
        return System.getenv(name);
    }
}

