/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.smartcardio.CardException;
import net.jsign.DigestAlgorithm;
import net.jsign.jca.CryptoCertumCard;
import net.jsign.jca.SigningService;
import net.jsign.jca.SigningServicePrivateKey;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;

public class CryptoCertumCardSigningService
implements SigningService {
    private final CryptoCertumCard card;

    public CryptoCertumCardSigningService(String pin) throws CardException {
        CryptoCertumCard card = CryptoCertumCard.getCard();
        if (card == null) {
            throw new CardException("CryptoCertum card not found");
        }
        this.card = card;
        this.card.verify(pin);
    }

    @Override
    public String getName() {
        return "CryptoCertum";
    }

    @Override
    public List<String> aliases() throws KeyStoreException {
        try {
            return this.card.aliases();
        }
        catch (CardException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public Certificate[] getCertificateChain(String alias) throws KeyStoreException {
        LinkedHashMap<String, X509Certificate> certificates = new LinkedHashMap<String, X509Certificate>();
        try {
            CryptoCertumCard.Certificate certificate = this.card.getCertificate(alias);
            if (certificate != null) {
                certificates.put(alias, certificate.getCertificate());
            }
        }
        catch (CardException e) {
            throw new KeyStoreException(e);
        }
        return certificates.values().toArray(new Certificate[0]);
    }

    @Override
    public SigningServicePrivateKey getPrivateKey(String alias, char[] password) throws UnrecoverableKeyException {
        try {
            CryptoCertumCard.Key key = this.card.getKey(alias);
            if (key != null) {
                SigningServicePrivateKey privateKey = new SigningServicePrivateKey(alias, key.type == 0 ? "RSA" : "ECDSA", this);
                privateKey.getProperties().put("key", key);
                return privateKey;
            }
        }
        catch (CardException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException().initCause(e);
        }
        throw new UnrecoverableKeyException("Key '" + alias + "' not found on the card");
    }

    @Override
    public byte[] sign(SigningServicePrivateKey privateKey, String algorithm, byte[] data) throws GeneralSecurityException {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.of(algorithm.substring(0, algorithm.toLowerCase().indexOf("with")));
        byte[] digest = digestAlgorithm.getMessageDigest().digest(data);
        CryptoCertumCard.Key key = (CryptoCertumCard.Key)privateKey.getProperties().get("key");
        try {
            if ("RSA".equals(privateKey.getAlgorithm())) {
                return this.card.sign(key, digest);
            }
            byte[] content = digest.length > key.size / 8 ? Arrays.copyOf(digest, key.size / 8) : digest;
            return this.toEcdsaSigValue(this.card.sign(key, content));
        }
        catch (IOException | CardException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private byte[] toEcdsaSigValue(byte[] p1363signature) throws IOException {
        DERSequence ecdsaSigValue = new DERSequence(new ASN1Encodable[]{new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(p1363signature, 0, p1363signature.length / 2))), new ASN1Integer(new BigInteger(1, Arrays.copyOfRange(p1363signature, p1363signature.length / 2, p1363signature.length)))});
        return ecdsaSigValue.getEncoded("DER");
    }
}

