/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.time.internal.properties.arbitraries;

import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.arbitraries.ArbitraryDecorator;
import net.jqwik.api.arbitraries.BigIntegerArbitrary;
import net.jqwik.time.api.arbitraries.DurationArbitrary;
import net.jqwik.time.internal.properties.arbitraries.DefaultLocalTimeArbitrary;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.DurationBetween;
import net.jqwik.time.internal.properties.arbitraries.valueRanges.OfPrecision;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public class DefaultDurationArbitrary
extends ArbitraryDecorator<Duration>
implements DurationArbitrary {
    public static final Duration DEFAULT_MIN = Duration.ofSeconds(Long.MIN_VALUE, 0L);
    public static final Duration DEFAULT_MIN_PRECISION_HOURS = Duration.ofSeconds(-9223372036854774000L, 0L);
    public static final Duration DEFAULT_MAX = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
    public static final Duration DEFAULT_MAX_PRECISION_HOURS = Duration.ofSeconds(9223372036854774000L, 0L);
    private final DurationBetween durationBetween = new DurationBetween();
    private final OfPrecision ofPrecision = new OfPrecision();

    protected Arbitrary<Duration> arbitrary() {
        Duration effectiveMin = this.effectiveMin(this.durationBetween, this.ofPrecision);
        Duration effectiveMax = this.effectiveMax(this.durationBetween, this.ofPrecision);
        BigInteger bigIntegerMin = this.valueFromDuration(effectiveMin, this.ofPrecision);
        BigInteger bigIntegerMax = this.valueFromDuration(effectiveMax, this.ofPrecision);
        Arbitrary bigIntegers = ((BigIntegerArbitrary)Arbitraries.bigIntegers().between(bigIntegerMin, bigIntegerMax).withDistribution(RandomDistribution.uniform())).edgeCases(edgeCases -> edgeCases.includeOnly((Object[])new BigInteger[]{bigIntegerMin, BigInteger.ZERO, bigIntegerMax}));
        return bigIntegers.map(this.ofPrecision::durationFromValue);
    }

    private Duration effectiveMin(DurationBetween durationBetween, OfPrecision ofPrecision) {
        Duration effective = durationBetween.getMin() != null ? (Duration)durationBetween.getMin() : ofPrecision.minPossibleDuration();
        this.checkValueAndPrecision(effective, ofPrecision, true);
        return effective;
    }

    private void checkValueAndPrecision(Duration effective, OfPrecision ofPrecision, boolean minimum) {
        int nanos;
        int seconds;
        int minutes = (int)(effective.getSeconds() % 3600L / 60L);
        if (!ofPrecision.valueWithPrecisionIsAllowed(minutes, seconds = (int)(effective.getSeconds() % 60L), nanos = effective.getNano())) {
            DefaultDurationArbitrary.throwDurationAndPrecisionException(effective.toString(), minimum, ofPrecision.get());
        }
    }

    private static void throwDurationAndPrecisionException(String val, boolean minimum, ChronoUnit precision) {
        String minMax = minimum ? "minimum" : "maximum";
        throw new IllegalArgumentException(String.format("Can't use %s as %s duration with precision %s.%nYou may want to round the duration to %s or change the precision.", val, minMax, precision, precision));
    }

    private Duration effectiveMax(DurationBetween durationBetween, OfPrecision ofPrecision) {
        Duration effective = durationBetween.getMax() != null ? (Duration)durationBetween.getMax() : ofPrecision.maxPossibleDuration();
        this.checkValueAndPrecision(effective, ofPrecision, false);
        return effective;
    }

    private BigInteger valueFromDuration(Duration effective, OfPrecision ofPrecision) {
        BigInteger helperMultiply = new BigInteger("1000000000");
        BigInteger helperDivide1000 = new BigInteger("1000");
        BigInteger helperDivide60 = new BigInteger("60");
        BigInteger bigInteger = new BigInteger(effective.getSeconds() + "");
        bigInteger = bigInteger.multiply(helperMultiply);
        bigInteger = bigInteger.add(new BigInteger(effective.getNano() + ""));
        if (ofPrecision.isGreatherThan(ChronoUnit.NANOS)) {
            bigInteger = bigInteger.divide(helperDivide1000);
            if (ofPrecision.isGreatherThan(ChronoUnit.MICROS)) {
                bigInteger = bigInteger.divide(helperDivide1000);
                if (ofPrecision.isGreatherThan(ChronoUnit.MILLIS)) {
                    bigInteger = bigInteger.divide(helperDivide1000);
                    if (ofPrecision.isGreatherThan(ChronoUnit.SECONDS)) {
                        bigInteger = bigInteger.divide(helperDivide60);
                        if (ofPrecision.isGreatherThan(ChronoUnit.MINUTES)) {
                            bigInteger = bigInteger.divide(helperDivide60);
                        }
                    }
                }
            }
        }
        return bigInteger;
    }

    private void setOfPrecisionImplicitly(DefaultDurationArbitrary clone, Duration duration) {
        if (clone.ofPrecision.isSet()) {
            return;
        }
        ChronoUnit ofPrecision = DefaultLocalTimeArbitrary.ofPrecisionFromNanos(duration.getNano());
        if (clone.ofPrecision.isGreatherThan(ofPrecision)) {
            clone.ofPrecision.setProgrammatically(ofPrecision);
        }
    }

    private void setOfPrecisionImplicitly(DefaultDurationArbitrary clone) {
        this.setOfPrecisionImplicitly(clone, (Duration)clone.durationBetween.getMin());
        this.setOfPrecisionImplicitly(clone, (Duration)clone.durationBetween.getMax());
    }

    @Override
    public DurationArbitrary between(Duration min, Duration max) {
        DefaultDurationArbitrary clone = (DefaultDurationArbitrary)this.typedClone();
        clone.durationBetween.set(min, max);
        this.setOfPrecisionImplicitly(clone);
        return clone;
    }

    @Override
    public DurationArbitrary ofPrecision(ChronoUnit ofPrecision) {
        DefaultDurationArbitrary clone = (DefaultDurationArbitrary)this.typedClone();
        clone.ofPrecision.set(ofPrecision);
        return clone;
    }
}

