/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries.randomized;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.TooManyFilterMissesException;
import net.jqwik.engine.properties.FeatureExtractor;
import net.jqwik.engine.properties.UniquenessChecker;
import net.jqwik.engine.properties.arbitraries.randomized.SizeGenerator;

class ContainerGenerator<T, C>
implements RandomGenerator<C> {
    private final RandomGenerator<T> elementGenerator;
    private final Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable;
    private final int minSize;
    private final long maxUniqueElements;
    private final Collection<FeatureExtractor<T>> uniquenessExtractors;
    private final Function<Random, Integer> sizeGenerator;
    private final long maxAttempts;

    private static Function<Random, Integer> sizeGenerator(int minSize, int maxSize, int genSize, RandomDistribution sizeDistribution) {
        return SizeGenerator.create(minSize, maxSize, genSize, sizeDistribution);
    }

    ContainerGenerator(RandomGenerator<T> elementGenerator, Function<List<Shrinkable<T>>, Shrinkable<C>> createShrinkable, int minSize, int maxSize, long maxUniqueElements, int genSize, RandomDistribution sizeDistribution, Collection<FeatureExtractor<T>> uniquenessExtractors) {
        this.elementGenerator = elementGenerator;
        this.createShrinkable = createShrinkable;
        this.minSize = minSize;
        this.maxUniqueElements = maxUniqueElements;
        this.uniquenessExtractors = uniquenessExtractors;
        this.sizeGenerator = ContainerGenerator.sizeGenerator(minSize, maxSize, genSize, sizeDistribution);
        this.maxAttempts = Math.min(10000L, Math.max(1000L, maxUniqueElements * 10L));
    }

    public Shrinkable<C> next(Random random) {
        AbstractCollection existingValues;
        int listSize = this.sizeGenerator.apply(random);
        ArrayList listOfShrinkables = new ArrayList();
        boolean noDuplicates = listSize >= 2 && (long)listSize <= this.maxUniqueElements && this.uniquenessExtractors.isEmpty() && random.nextInt(100) <= 2;
        int sizeToShuffleIfExceeded = Integer.MAX_VALUE;
        boolean canUseSetForValues = this.uniquenessExtractors.isEmpty() || this.uniquenessExtractors.contains(FeatureExtractor.identity());
        AbstractCollection abstractCollection = existingValues = canUseSetForValues ? new HashSet() : new ArrayList();
        while (listOfShrinkables.size() < listSize) {
            try {
                Shrinkable next = this.nextUntilAccepted(random, existingValues, arg_0 -> this.elementGenerator.next(arg_0), noDuplicates);
                listOfShrinkables.add(next);
            }
            catch (TooManyFilterMissesException tooManyFailedGenerationAttempts) {
                if (noDuplicates) {
                    noDuplicates = false;
                    sizeToShuffleIfExceeded = listOfShrinkables.size();
                    continue;
                }
                if (listOfShrinkables.size() >= this.minSize) break;
                throw tooManyFailedGenerationAttempts;
            }
        }
        if (listOfShrinkables.size() > sizeToShuffleIfExceeded) {
            Collections.shuffle(listOfShrinkables, random);
        }
        return this.createShrinkable.apply(listOfShrinkables);
    }

    private Shrinkable<T> nextUntilAccepted(Random random, Collection<T> existingValues, Function<Random, Shrinkable<T>> fetchShrinkable, boolean noDuplicates) {
        int i = 0;
        while ((long)i < this.maxAttempts) {
            Shrinkable<T> next = fetchShrinkable.apply(random);
            Object value = next.value();
            if (!(noDuplicates && existingValues.contains(value) || !this.checkSpecifiedUniqueness(existingValues, value))) {
                existingValues.add(value);
                return next;
            }
            ++i;
        }
        String message = String.format("Trying to fulfill uniqueness constraint missed more than %s times.", this.maxAttempts);
        throw new TooManyFilterMissesException(message);
    }

    private boolean checkSpecifiedUniqueness(Collection<T> elements, T value) {
        return UniquenessChecker.checkValueUniqueIn(this.uniquenessExtractors, value, elements);
    }
}

