/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class JustArbitrary<T>
implements Arbitrary<T> {
    private final T value;

    public JustArbitrary(T value) {
        this.value = value;
    }

    public <U> Arbitrary<U> flatMap(Function<T, Arbitrary<U>> mapper) {
        return mapper.apply(this.value);
    }

    public <U> Arbitrary<U> map(Function<T, U> mapper) {
        return new JustArbitrary<U>(mapper.apply(this.value));
    }

    public RandomGenerator<T> generator(int tries) {
        return random -> Shrinkable.unshrinkable(this.value);
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.choose(Arrays.asList(this.value), maxNumberOfSamples);
    }

    public EdgeCases<T> edgeCases(int maxEdgeCases1) {
        return maxEdgeCases1 <= 0 ? EdgeCases.none() : EdgeCases.fromSupplier(() -> Shrinkable.unshrinkable(this.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JustArbitrary that = (JustArbitrary)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

