/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.Consumer;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.EdgeCases;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomDistribution;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.ShortArbitrary;
import net.jqwik.engine.properties.arbitraries.EdgeCasesSupport;
import net.jqwik.engine.properties.arbitraries.IntegralGeneratingArbitrary;
import net.jqwik.engine.properties.arbitraries.MappedEdgeCasesConsumer;
import net.jqwik.engine.properties.arbitraries.TypedCloneable;

public class DefaultShortArbitrary
extends TypedCloneable
implements ShortArbitrary {
    private static final short DEFAULT_MIN = Short.MIN_VALUE;
    private static final short DEFAULT_MAX = Short.MAX_VALUE;
    private IntegralGeneratingArbitrary generatingArbitrary = new IntegralGeneratingArbitrary(BigInteger.valueOf(-32768L), BigInteger.valueOf(32767L));

    public RandomGenerator<Short> generator(int genSize) {
        return this.generatingArbitrary.generator(genSize).map(BigInteger::shortValueExact);
    }

    public Optional<ExhaustiveGenerator<Short>> exhaustive(long maxNumberOfSamples) {
        return this.generatingArbitrary.exhaustive(maxNumberOfSamples).map(generator -> generator.map(BigInteger::shortValueExact));
    }

    public EdgeCases<Short> edgeCases(int maxEdgeCases) {
        return EdgeCasesSupport.map(this.generatingArbitrary.edgeCases(maxEdgeCases), BigInteger::shortValueExact);
    }

    public Arbitrary<Short> edgeCases(Consumer<EdgeCases.Config<Short>> configurator) {
        MappedEdgeCasesConsumer<Short, BigInteger> integralConfigurator = new MappedEdgeCasesConsumer<Short, BigInteger>(configurator, BigInteger::shortValueExact, BigInteger::valueOf);
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary = (IntegralGeneratingArbitrary)this.generatingArbitrary.edgeCases(integralConfigurator);
        return clone;
    }

    public ShortArbitrary withDistribution(RandomDistribution distribution) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.distribution = distribution;
        return clone;
    }

    public ShortArbitrary greaterOrEqual(short min) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.min = BigInteger.valueOf(min);
        return clone;
    }

    public ShortArbitrary lessOrEqual(short max) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.max = BigInteger.valueOf(max);
        return clone;
    }

    public Arbitrary<Short> shrinkTowards(short target) {
        DefaultShortArbitrary clone = (DefaultShortArbitrary)this.typedClone();
        clone.generatingArbitrary.shrinkingTarget = BigInteger.valueOf(target);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultShortArbitrary that = (DefaultShortArbitrary)o;
        return this.generatingArbitrary.equals(that.generatingArbitrary);
    }

    public int hashCode() {
        return this.generatingArbitrary.hashCode();
    }
}

