/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.jqwik.api.Data;
import net.jqwik.api.FromData;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.DataResolver;
import net.jqwik.engine.support.JqwikReflectionSupport;
import org.junit.platform.commons.support.AnnotationSupport;

public class PropertyMethodDataResolver
implements DataResolver {
    private final Class<?> containerClass;
    private final Object testInstance;

    public PropertyMethodDataResolver(Class<?> containerClass, Object testInstance) {
        this.containerClass = containerClass;
        this.testInstance = testInstance;
    }

    @Override
    public Optional<Iterable<? extends Tuple>> forMethod(Method method) {
        Optional optionalDataFrom = AnnotationSupport.findAnnotation((AnnotatedElement)method, FromData.class);
        return optionalDataFrom.map(FromData::value).map(generatorName -> {
            Supplier<JqwikException> exceptionSupplier = () -> new JqwikException("No data provider method (annotated with @Data) for generator [" + generatorName + "] found");
            return this.findGenerator((String)generatorName).orElseThrow(exceptionSupplier);
        }).map(generatorMethod -> JqwikReflectionSupport.invokeMethodPotentiallyOuter(generatorMethod, this.testInstance, new Object[0])).map(invocationResult -> (Iterable)invocationResult);
    }

    private Optional<Method> findGenerator(String generatorName) {
        Function<Method, String> generatorNameSupplier = method -> {
            Data generateAnnotation = method.getDeclaredAnnotation(Data.class);
            return generateAnnotation.value();
        };
        TypeUsage expectedReturnType = TypeUsage.of(Iterable.class, (TypeUsage[])new TypeUsage[]{TypeUsage.wildcard((TypeUsage)TypeUsage.of(Tuple.class, (TypeUsage[])new TypeUsage[0]))});
        return JqwikReflectionSupport.findGeneratorMethod(generatorName, this.containerClass, Data.class, generatorNameSupplier, expectedReturnType);
    }
}

