/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.hooks.statistics;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.jqwik.api.statistics.StatisticsEntry;
import net.jqwik.api.statistics.StatisticsReportFormat;

public class StandardStatisticsReportFormat
implements StatisticsReportFormat {
    public List<String> formatReport(List<StatisticsEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("Entries must not be empty");
        }
        int maxKeyLength = entries.stream().mapToInt(entry -> entry.name().length()).max().orElse(0);
        boolean fullNumbersOnly = entries.stream().noneMatch(entry -> entry.percentage() < 1.0);
        int maxCount = entries.stream().mapToInt(StatisticsEntry::count).max().orElse(0);
        int decimals = (int)Math.max(1.0, Math.floor(Math.log10(maxCount)) + 1.0);
        return entries.stream().map(entry -> this.formatEntry((StatisticsEntry)entry, maxKeyLength, fullNumbersOnly, decimals)).collect(Collectors.toList());
    }

    private String formatEntry(StatisticsEntry statsEntry, int maxKeyLength, boolean fullNumbersOnly, int decimals) {
        return String.format(Locale.US, "%1$-" + maxKeyLength + "s (%2$" + decimals + "d) : %3$s %%", statsEntry.name(), statsEntry.count(), this.displayPercentage(statsEntry.percentage(), fullNumbersOnly));
    }

    private String displayPercentage(double percentage, boolean fullNumbersOnly) {
        if (fullNumbersOnly) {
            return String.format(Locale.US, "%2d", Math.round(percentage));
        }
        return String.format(Locale.US, "%5.2f", (double)Math.round(percentage * 100.0) / 100.0);
    }
}

