/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.facades;

import java.util.logging.Logger;
import net.jqwik.api.JqwikException;
import net.jqwik.api.sessions.JqwikSession;
import net.jqwik.engine.execution.lifecycle.CurrentTestDescriptor;
import net.jqwik.engine.execution.lifecycle.StoreRepository;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public class JqwikSessionFacadeImpl
extends JqwikSession.JqwikSessionFacade {
    private static final Logger LOG = Logger.getLogger(JqwikSession.class.getName());
    private static final TestDescriptor SESSION_DESCRIPTOR = new AbstractTestDescriptor(UniqueId.root((String)"jqwik", (String)"session"), "Streaming samples outside jqwik thread"){

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }
    };

    public void startSession() {
        if (!CurrentTestDescriptor.isEmpty()) {
            if (CurrentTestDescriptor.get() == SESSION_DESCRIPTOR) {
                throw new JqwikException("JqwikSession.start() cannot be nested");
            }
            throw new JqwikException("JqwikSession.start() must only be used outside jqwik's standard lifecycle");
        }
        CurrentTestDescriptor.push(SESSION_DESCRIPTOR);
    }

    public void finishSession() {
        if (!this.isSessionOpen()) {
            LOG.warning("JqwikSession.finish() should be called within a session");
            return;
        }
        this.finishSessionLifecycle();
        CurrentTestDescriptor.pop();
    }

    public void finishTry() {
        if (!this.isSessionOpen()) {
            throw new JqwikException("JqwikSession.finishTry() must only be used within a JqwikSession");
        }
        StoreRepository.getCurrent().finishTry(SESSION_DESCRIPTOR);
    }

    public boolean isSessionOpen() {
        return !CurrentTestDescriptor.isEmpty() && CurrentTestDescriptor.get() == SESSION_DESCRIPTOR;
    }

    public void runInSession(JqwikSession.Runnable runnable) {
        try {
            JqwikSession.start();
            runnable.run();
        }
        catch (Throwable t) {
            JqwikExceptionSupport.throwAsUncheckedException(t);
        }
        finally {
            JqwikSession.finish();
        }
    }

    private void finishSessionLifecycle() {
        StoreRepository.getCurrent().finishTry(SESSION_DESCRIPTOR);
        StoreRepository.getCurrent().finishProperty(SESSION_DESCRIPTOR);
        StoreRepository.getCurrent().finishScope(SESSION_DESCRIPTOR);
    }
}

