/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.reporting;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Tuple;

class ParameterChangesDetector {
    ParameterChangesDetector() {
    }

    static boolean haveParametersChanged(List<Object> before, List<Object> after) {
        return ParameterChangesDetector.atLeastOneParameterHasChanged(before, after);
    }

    private static boolean atLeastOneParameterHasChanged(List<Object> before, List<Object> after) {
        if (before.size() != after.size()) {
            return true;
        }
        for (int i = 0; i < before.size(); ++i) {
            Object afterValue;
            Object beforeValue = before.get(i);
            if (!ParameterChangesDetector.valuesDiffer(beforeValue, afterValue = after.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean valuesDiffer(Object before, Object after) {
        if (Objects.isNull(before) != Objects.isNull(after)) {
            return true;
        }
        if (Objects.isNull(before)) {
            return false;
        }
        if (before.getClass() != after.getClass()) {
            return true;
        }
        if (before instanceof Tuple) {
            return ParameterChangesDetector.tupleValuesDiffer((Tuple)before, (Tuple)after);
        }
        if (ParameterChangesDetector.hasOwnEqualsImplementation(before.getClass())) {
            return !Objects.equals(before, after);
        }
        return false;
    }

    private static boolean tupleValuesDiffer(Tuple before, Tuple after) {
        return ParameterChangesDetector.atLeastOneParameterHasChanged(before.items(), after.items());
    }

    private static boolean hasOwnEqualsImplementation(Class<?> aClass) {
        if (Proxy.isProxyClass(aClass)) {
            return false;
        }
        return !ParameterChangesDetector.equalsMethod(aClass).equals(ParameterChangesDetector.equalsMethod(Object.class));
    }

    private static Method equalsMethod(Class<?> aClass) {
        try {
            return aClass.getMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new JqwikException("All classes should have an equals() method");
        }
    }
}

