/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.api.Tuple;
import net.jqwik.api.lifecycle.CannotResolveParameterException;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.engine.support.JqwikStringSupport;

class CombinedResolveParameterHook
implements ResolveParameterHook {
    private List<ResolveParameterHook> resolveParameterHooks;

    public CombinedResolveParameterHook(List<ResolveParameterHook> resolveParameterHooks) {
        this.resolveParameterHooks = resolveParameterHooks;
    }

    public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext) {
        List resolvers = this.resolveParameterHooks.stream().map(hook -> Tuple.of((Object)hook, (Object)hook.resolve(parameterContext, lifecycleContext))).filter(tuple -> ((Optional)tuple.get2()).isPresent()).collect(Collectors.toList());
        if (resolvers.isEmpty()) {
            return Optional.empty();
        }
        if (resolvers.size() > 1) {
            List resolverTypes = resolvers.stream().map(tuple -> ((ResolveParameterHook)tuple.get1()).getClass()).collect(Collectors.toList());
            String info = String.format("Competing resolvers %s", JqwikStringSupport.displayString(resolverTypes));
            throw new CannotResolveParameterException(parameterContext, info);
        }
        return (Optional)((Tuple.Tuple2)resolvers.get(0)).get2();
    }
}

