/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.jqwik.api.Shrinkable;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public class ShrinkingDistance
implements Comparable<ShrinkingDistance> {
    @API(status=API.Status.MAINTAINED, since="1.2.0")
    public static final ShrinkingDistance MAX = ShrinkingDistance.of(Long.MAX_VALUE);
    private final long[] distances;

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static ShrinkingDistance of(long ... distances) {
        return new ShrinkingDistance(distances);
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <T> ShrinkingDistance forCollection(Collection<Shrinkable<T>> elements) {
        ShrinkingDistance sumDistanceOfElements = elements.stream().map(Shrinkable::distance).reduce(ShrinkingDistance.of(0L), ShrinkingDistance::plus);
        return ShrinkingDistance.of(elements.size()).append(sumDistanceOfElements);
    }

    @API(status=API.Status.MAINTAINED, since="1.0")
    public static <T> ShrinkingDistance combine(List<Shrinkable<T>> shrinkables) {
        return shrinkables.stream().map(Shrinkable::distance).reduce(new ShrinkingDistance(new long[0]), ShrinkingDistance::append);
    }

    private ShrinkingDistance(long[] distances) {
        this.distances = distances;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkingDistance that = (ShrinkingDistance)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.distances);
    }

    public String toString() {
        return String.format("ShrinkingDistance:%s", Arrays.toString(this.distances));
    }

    @Override
    public int compareTo(ShrinkingDistance other) {
        if (this == MAX) {
            if (other == MAX) {
                return 0;
            }
            return 1;
        }
        if (other == MAX) {
            return -1;
        }
        int dimensionsToCompare = Math.max(this.size(), other.size());
        for (int i = 0; i < dimensionsToCompare; ++i) {
            int compareDimensionResult = this.compareDimension(other, i);
            if (compareDimensionResult == 0) continue;
            return compareDimensionResult;
        }
        return 0;
    }

    @API(status=API.Status.INTERNAL)
    public List<ShrinkingDistance> dimensions() {
        return Arrays.stream(this.distances).mapToObj(xva$0 -> ShrinkingDistance.of(xva$0)).collect(Collectors.toList());
    }

    @API(status=API.Status.INTERNAL)
    public int size() {
        return this.distances.length;
    }

    private int compareDimension(ShrinkingDistance other, int i) {
        long left = this.at(this.distances, i);
        long right = this.at(other.distances, i);
        return Long.compare(left, right);
    }

    private long at(long[] array, int i) {
        return array.length > i ? array[i] : 0L;
    }

    @API(status=API.Status.INTERNAL)
    public ShrinkingDistance plus(ShrinkingDistance other) {
        long[] summedUpDistances = this.sumUpArrays(this.distances, other.distances);
        return new ShrinkingDistance(summedUpDistances);
    }

    private long[] sumUpArrays(long[] left, long[] right) {
        long[] sum = new long[Math.max(left.length, right.length)];
        for (int i = 0; i < sum.length; ++i) {
            long summedValue = this.at(left, i) + this.at(right, i);
            if (summedValue < 0L) {
                summedValue = Long.MAX_VALUE;
            }
            sum[i] = summedValue;
        }
        return sum;
    }

    @API(status=API.Status.INTERNAL)
    public ShrinkingDistance append(ShrinkingDistance other) {
        long[] appendedDistances = this.concatArrays(this.distances, other.distances);
        return new ShrinkingDistance(appendedDistances);
    }

    private long[] concatArrays(long[] left, long[] right) {
        long[] concatenated = Arrays.copyOf(left, left.length + right.length);
        System.arraycopy(right, 0, concatenated, left.length, right.length);
        return concatenated;
    }
}

