/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common.client;

import java.util.Collections;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.javacrumbs.smock.common.SmockCommon;
import net.javacrumbs.smock.common.TemplateAwareMessageCreator;
import net.javacrumbs.smock.common.TemplateAwareMessageMatcher;
import net.javacrumbs.smock.common.client.ParametrizableRequestMatcher;
import net.javacrumbs.smock.common.client.ParametrizableResponseCreator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.w3c.dom.Document;

public abstract class CommonSmockClient
extends SmockCommon {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();

    public static ParametrizableRequestMatcher message(String location) {
        Assert.notNull((Object)location, (String)"'location' must not be null");
        return CommonSmockClient.message(CommonSmockClient.fromResource(location));
    }

    public static ParametrizableRequestMatcher message(Resource message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return CommonSmockClient.message(CommonSmockClient.createSource(message));
    }

    public static ParametrizableRequestMatcher message(Source message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return new TemplateAwareMessageMatcher(message, EMPTY_MAP, CommonSmockClient.getTemplateProcessor());
    }

    public static ParametrizableRequestMatcher message(Document message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return CommonSmockClient.message(new DOMSource(message));
    }

    public static ParametrizableResponseCreator withMessage(String location) {
        Assert.notNull((Object)location, (String)"'location' must not be null");
        return CommonSmockClient.withMessage(CommonSmockClient.fromResource(location));
    }

    public static ParametrizableResponseCreator withMessage(Resource message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return CommonSmockClient.withMessage(CommonSmockClient.createSource(message));
    }

    public static ParametrizableResponseCreator withMessage(Source message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return new TemplateAwareMessageCreator(message, EMPTY_MAP, CommonSmockClient.getTemplateProcessor());
    }

    public static ParametrizableResponseCreator withMessage(Document message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        return CommonSmockClient.withMessage(new DOMSource(message));
    }
}

