/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common.client;

import javax.xml.transform.Source;
import net.javacrumbs.smock.common.MessageHelper;
import net.javacrumbs.smock.common.client.CommonSmockClient;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.test.client.ResponseCreator;
import org.springframework.ws.test.support.AssertionErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTestHelper
extends CommonSmockClient {
    private static WebServiceMessageFactory messageFactory = ClientTestHelper.createMessageFactory();
    private static MessageHelper messageHelper = new MessageHelper(messageFactory);

    public static <T> T response(String messageLocation, Class<T> responseType) {
        return ClientTestHelper.response(ClientTestHelper.fromResource(messageLocation), responseType);
    }

    public static <T> T response(Source messageSource, Class<T> responseType) {
        return ClientTestHelper.response(ClientTestHelper.withMessage(messageSource), null, responseType);
    }

    public static <T> T response(ResponseCreator requestCreator, WebServiceMessage request, Class<T> responseType) {
        try {
            return messageHelper.deserialize(requestCreator.createResponse(null, request, messageFactory), responseType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not deserialize message.", e);
        }
    }

    public static WebServiceMessage serialize(Object object) {
        try {
            WebServiceMessage message = messageHelper.serialize(object);
            if (message == null) {
                AssertionErrors.fail((String)("Can not serialize object " + object));
            }
            return message;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not serialize object.", e);
        }
    }

    public static WebServiceMessageFactory getMessageFactory() {
        return messageFactory;
    }

    public static void setMessageFactory(WebServiceMessageFactory messageFactory) {
        ClientTestHelper.messageFactory = messageFactory;
    }

    public static MessageHelper getMessageHelper() {
        return messageHelper;
    }

    public static void setMessageHelper(MessageHelper messageHelper) {
        ClientTestHelper.messageHelper = messageHelper;
    }
}

