/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.context.DefaultMessageContext;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.adapter.DefaultMethodEndpointAdapter;
import org.springframework.ws.server.endpoint.adapter.method.MethodArgumentResolver;
import org.springframework.ws.server.endpoint.adapter.method.MethodReturnValueHandler;
import org.springframework.ws.server.endpoint.annotation.RequestPayload;
import org.springframework.ws.server.endpoint.annotation.ResponsePayload;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHelper {
    private DefaultMethodEndpointAdapter adapter;
    private final WebServiceMessageFactory messageFactory;

    public MessageHelper(WebServiceMessageFactory messageFactory) {
        Assert.notNull((Object)messageFactory, (String)"Message factory can not be null");
        this.adapter = new DefaultMethodEndpointAdapter();
        this.messageFactory = messageFactory;
        try {
            this.adapter.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IllegalStateException("Initialization failed.", e);
        }
    }

    public <T> T deserialize(WebServiceMessage message, Class<T> targetClass) throws Exception {
        Assert.notNull((Object)message, (String)"message can not be null");
        Assert.notNull(targetClass, (String)"targetClass can not be null");
        SmockMethodParameter parameter = new SmockMethodParameter(targetClass, 0);
        DefaultMessageContext messageContext = new DefaultMessageContext(message, this.messageFactory);
        for (MethodArgumentResolver resolver : this.adapter.getMethodArgumentResolvers()) {
            Object result;
            if (!resolver.supportsParameter((MethodParameter)parameter) || (result = resolver.resolveArgument((MessageContext)messageContext, (MethodParameter)parameter)) == null) continue;
            return (T)result;
        }
        return null;
    }

    public WebServiceMessage serialize(Object data) throws Exception {
        Assert.notNull((Object)data, (String)"data can not be null");
        SmockMethodParameter parameter = new SmockMethodParameter(this.getTargetClass(data), -1);
        DefaultMessageContext messageContext = new DefaultMessageContext(this.messageFactory);
        for (MethodReturnValueHandler methodReturnValueHandler : this.adapter.getMethodReturnValueHandlers()) {
            if (!methodReturnValueHandler.supportsReturnType((MethodParameter)parameter)) continue;
            methodReturnValueHandler.handleReturnValue((MessageContext)messageContext, (MethodParameter)parameter, data);
            return messageContext.getResponse();
        }
        return null;
    }

    protected Class<? extends Object> getTargetClass(Object data) {
        if (Element.class.isAssignableFrom(data.getClass())) {
            return Element.class;
        }
        return data.getClass();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SmockMethodParameter
    extends MethodParameter {
        private final Class<?> parameterType;

        public SmockMethodParameter(Class<?> parameterType, int parameterIndex) {
            super(SmockMethodParameter.getDummyMethod(), parameterIndex);
            this.parameterType = parameterType;
        }

        private static Method getDummyMethod() {
            try {
                return SmockMethodParameter.class.getMethod("dummyMethod", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Should not happen.", e);
            }
        }

        public Class<?> getParameterType() {
            return this.parameterType;
        }

        @ResponsePayload
        public String dummyMethod(@RequestPayload String param) {
            return null;
        }
    }
}

