/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;

public class EndpointInterceptorClientAdapter
implements ClientInterceptor {
    private final EndpointInterceptor interceptor;

    public EndpointInterceptorClientAdapter(EndpointInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static ClientInterceptor[] wrapEndpointInterceptors(EndpointInterceptor[] endpointInterceptors) {
        if (endpointInterceptors != null) {
            ClientInterceptor[] result = new ClientInterceptor[endpointInterceptors.length];
            for (int i = 0; i < endpointInterceptors.length; ++i) {
                result[i] = new EndpointInterceptorClientAdapter(endpointInterceptors[i]);
            }
            return result;
        }
        return new ClientInterceptor[0];
    }

    public boolean handleFault(MessageContext messageContext) throws WebServiceClientException {
        try {
            return this.interceptor.handleFault(messageContext, null);
        }
        catch (Exception e) {
            throw new ServerSideInterceptorWebServiceClientException(e);
        }
    }

    public boolean handleRequest(MessageContext messageContext) throws WebServiceClientException {
        try {
            return this.interceptor.handleRequest(messageContext, null);
        }
        catch (Exception e) {
            throw new ServerSideInterceptorWebServiceClientException(e);
        }
    }

    public boolean handleResponse(MessageContext messageContext) throws WebServiceClientException {
        try {
            return this.interceptor.handleResponse(messageContext, null);
        }
        catch (Exception e) {
            throw new ServerSideInterceptorWebServiceClientException(e);
        }
    }

    private static final class ServerSideInterceptorWebServiceClientException
    extends WebServiceClientException {
        private static final long serialVersionUID = -1658208004293097418L;

        public ServerSideInterceptorWebServiceClientException(Exception e) {
            super("Exception thrown by interceptors injected by test.", (Throwable)e);
        }
    }
}

