/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.scheduling.support.ScheduledMethodRunnable;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

class SpringLockConfigurationExtractor
implements LockConfigurationExtractor {
    private final TemporalAmount defaultLockAtMostFor;
    private final TemporalAmount defaultLockAtLeastFor;
    private final StringValueResolver embeddedValueResolver;
    private final Converter<String, Duration> durationConverter;
    private final Logger logger = LoggerFactory.getLogger(SpringLockConfigurationExtractor.class);

    public SpringLockConfigurationExtractor(@NotNull TemporalAmount defaultLockAtMostFor, @NotNull TemporalAmount defaultLockAtLeastFor, @Nullable StringValueResolver embeddedValueResolver, @NotNull Converter<String, Duration> durationConverter) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
        this.durationConverter = Objects.requireNonNull(durationConverter);
        this.embeddedValueResolver = embeddedValueResolver;
    }

    @NotNull
    public Optional<LockConfiguration> getLockConfiguration(@NotNull Runnable task) {
        if (task instanceof ScheduledMethodRunnable) {
            ScheduledMethodRunnable scheduledMethodRunnable = (ScheduledMethodRunnable)task;
            return this.getLockConfiguration(scheduledMethodRunnable.getTarget(), scheduledMethodRunnable.getMethod());
        }
        this.logger.debug("Unknown task type " + task);
        return Optional.empty();
    }

    public Optional<LockConfiguration> getLockConfiguration(Object target, Method method) {
        AnnotationData annotation = this.findAnnotation(target, method);
        if (this.shouldLock(annotation)) {
            return Optional.of(this.getLockConfiguration(annotation));
        }
        return Optional.empty();
    }

    private LockConfiguration getLockConfiguration(AnnotationData annotation) {
        Instant now = Instant.now();
        return new LockConfiguration(this.getName(annotation), now.plus(this.getLockAtMostFor(annotation)), now.plus(this.getLockAtLeastFor(annotation)));
    }

    private String getName(AnnotationData annotation) {
        if (this.embeddedValueResolver != null) {
            return this.embeddedValueResolver.resolveStringValue(annotation.getName());
        }
        return annotation.getName();
    }

    TemporalAmount getLockAtMostFor(AnnotationData annotation) {
        return this.getValue(annotation.getLockAtMostFor(), annotation.getLockAtMostForString(), this.defaultLockAtMostFor, "lockAtMostForString");
    }

    TemporalAmount getLockAtLeastFor(AnnotationData annotation) {
        return this.getValue(annotation.getLockAtLeastFor(), annotation.getLockAtLeastForString(), this.defaultLockAtLeastFor, "lockAtLeastForString");
    }

    private TemporalAmount getValue(long valueFromAnnotation, String stringValueFromAnnotation, TemporalAmount defaultValue, String paramName) {
        if (valueFromAnnotation >= 0L) {
            return Duration.of(valueFromAnnotation, ChronoUnit.MILLIS);
        }
        if (StringUtils.hasText((String)stringValueFromAnnotation)) {
            if (this.embeddedValueResolver != null) {
                stringValueFromAnnotation = this.embeddedValueResolver.resolveStringValue(stringValueFromAnnotation);
            }
            try {
                Duration result = (Duration)this.durationConverter.convert((Object)stringValueFromAnnotation);
                if (result.isNegative()) {
                    throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot set negative duration");
                }
                return result;
            }
            catch (IllegalStateException nfe) {
                throw new IllegalArgumentException("Invalid " + paramName + " value \"" + stringValueFromAnnotation + "\" - cannot parse into long nor duration");
            }
        }
        return defaultValue;
    }

    AnnotationData findAnnotation(Object target, Method method) {
        AnnotationData annotation = this.findAnnotation(method);
        if (annotation != null) {
            return annotation;
        }
        Class targetClass = AopUtils.getTargetClass((Object)target);
        if (targetClass != null) {
            try {
                Method methodOnTarget = targetClass.getMethod(method.getName(), method.getParameterTypes());
                return this.findAnnotation(methodOnTarget);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private AnnotationData findAnnotation(Method method) {
        net.javacrumbs.shedlock.core.SchedulerLock annotation = (net.javacrumbs.shedlock.core.SchedulerLock)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, net.javacrumbs.shedlock.core.SchedulerLock.class);
        if (annotation != null) {
            return new AnnotationData(annotation.name(), annotation.lockAtMostFor(), annotation.lockAtMostForString(), annotation.lockAtLeastFor(), annotation.lockAtLeastForString());
        }
        SchedulerLock annotation2 = (SchedulerLock)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, SchedulerLock.class);
        if (annotation2 != null) {
            return new AnnotationData(annotation2.name(), -1L, annotation2.lockAtMostFor(), -1L, annotation2.lockAtLeastFor());
        }
        return null;
    }

    private boolean shouldLock(AnnotationData annotation) {
        return annotation != null;
    }

    static class AnnotationData {
        private final String name;
        private final long lockAtMostFor;
        private final String lockAtMostForString;
        private final long lockAtLeastFor;
        private final String lockAtLeastForString;

        private AnnotationData(String name, long lockAtMostFor, String lockAtMostForString, long lockAtLeastFor, String lockAtLeastForString) {
            this.name = name;
            this.lockAtMostFor = lockAtMostFor;
            this.lockAtMostForString = lockAtMostForString;
            this.lockAtLeastFor = lockAtLeastFor;
            this.lockAtLeastForString = lockAtLeastForString;
        }

        public String getName() {
            return this.name;
        }

        public long getLockAtMostFor() {
            return this.lockAtMostFor;
        }

        public String getLockAtMostForString() {
            return this.lockAtMostForString;
        }

        public long getLockAtLeastFor() {
            return this.lockAtLeastFor;
        }

        public String getLockAtLeastForString() {
            return this.lockAtLeastForString;
        }
    }
}

