/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import de.schlichtherle.truezip.file.TFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.java.truelicense.maven.plugin.obfuscation.Collector;
import net.java.truelicense.maven.plugin.obfuscation.FirstPass;
import net.java.truelicense.maven.plugin.obfuscation.Merger;
import net.java.truelicense.maven.plugin.obfuscation.Obfuscator;
import net.java.truelicense.maven.plugin.obfuscation.SecondPass;
import net.java.truelicense.maven.plugin.obfuscation.SubjectLogger;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;

public final class Processor
implements Runnable {
    public static final int DEFAULT_MAX_BYTES = 65536;
    public static final boolean DEFAULT_OBFUSCATE_ALL = false;
    public static final String DEFAULT_METHOD_NAME_FORMAT = "_%s#%d";
    public static final boolean DEFAULT_INTERN_STRINGS = true;
    private final Set<String> constantStrings = new HashSet<String>();
    private final Logger logger;
    private final TFile directory;
    private final int maxBytes;
    private final boolean obfuscateAll;
    private final String methodNameFormat;
    private final boolean internStrings;

    public static Builder builder() {
        return new Builder();
    }

    Processor(Builder builder) {
        this.logger = Processor.requireNonNull(builder.logger);
        this.directory = builder.directory instanceof TFile ? (TFile)builder.directory : new TFile(builder.directory);
        this.maxBytes = Processor.nonNullOr(builder.maxBytes, 65536);
        if (0 >= this.maxBytes) {
            throw new IllegalArgumentException();
        }
        this.obfuscateAll = Processor.nonNullOr(builder.obfuscateAll, false);
        this.methodNameFormat = Processor.nonNullOr(builder.methodNameFormat, DEFAULT_METHOD_NAME_FORMAT);
        this.internStrings = Processor.nonNullOr(builder.internStrings, true);
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    private static <T> T requireNonNull(@Nullable T t) {
        if (null == t) {
            throw new NullPointerException();
        }
        return t;
    }

    private static <T> T nonNullOr(@Nullable T t, T t2) {
        return null != t ? t : t2;
    }

    public Logger logger() {
        return this.logger;
    }

    public File directory() {
        return this.directory;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public boolean obfuscateAll() {
        return this.obfuscateAll;
    }

    public String methodNameFormat() {
        return this.methodNameFormat;
    }

    public boolean internStrings() {
        return this.internStrings;
    }

    Set<String> constantStrings() {
        return this.constantStrings;
    }

    Logger logger(String string) {
        return new SubjectLogger(this.logger(), string);
    }

    String methodName(String string, int n) {
        return new Formatter().format(this.methodNameFormat(), string, n).toString();
    }

    @Override
    public void run() {
        this.firstPass().run();
        this.secondPass().run();
    }

    Runnable firstPass() {
        return new FirstPass(this);
    }

    Runnable secondPass() {
        return new SecondPass(this);
    }

    ClassVisitor collector() {
        return new Collector(this);
    }

    ClassVisitor obfuscator(ClassVisitor classVisitor) {
        return new Obfuscator(this, classVisitor);
    }

    ClassVisitor merger(ClassVisitor classVisitor, String string) {
        return new Merger(this, string, classVisitor);
    }

    public static final class Builder {
        @Nullable
        Logger logger;
        @Nullable
        File directory;
        @Nullable
        Integer maxBytes;
        @Nullable
        Boolean obfuscateAll;
        @Nullable
        String methodNameFormat;
        @Nullable
        Boolean internStrings;

        Builder() {
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder directory(File file) {
            this.directory = file;
            return this;
        }

        public Builder maxBytes(Integer n) {
            this.maxBytes = n;
            return this;
        }

        public Builder obfuscateAll(Boolean bl) {
            this.obfuscateAll = bl;
            return this;
        }

        public Builder methodNameFormat(String string) {
            this.methodNameFormat = string;
            return this;
        }

        public Builder internStrings(Boolean bl) {
            this.internStrings = bl;
            return this;
        }

        public Processor build() {
            return new Processor(this);
        }
    }
}

