/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin.obfuscation;

import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truelicense.maven.plugin.obfuscation.Node;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import org.slf4j.Logger;

@NotThreadSafe
abstract class Pass
implements Runnable {
    final Processor ctx;

    Pass(Processor processor) {
        this.ctx = processor;
    }

    final Logger logger() {
        return this.ctx.logger();
    }

    final Logger logger(Node node) {
        return this.ctx.logger(node.path());
    }

    final boolean obfuscateAll() {
        return this.ctx.obfuscateAll();
    }

    @Override
    public void run() {
        this.scan(new Node("", this.ctx.directory()));
    }

    private void scan(Node node) {
        File file = node.file();
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            if (null != stringArray) {
                for (String string : stringArray) {
                    this.scan(new Node(node, string));
                }
            } else {
                this.logger(node).error("Cannot list directory.");
            }
        } else if (file.isFile() && file.getName().endsWith(".class")) {
            this.process(node);
        } else {
            this.logger(node).trace("Skipping resource file.");
        }
    }

    abstract void process(Node var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    final byte[] read(Node node) throws IOException {
        int n;
        File file = node.file();
        long l = file.length();
        if (l > (long)(n = this.ctx.maxBytes())) {
            throw new IOException(String.format("%s (%,d bytes exceeds max %,d bytes)", file, l, n));
        }
        byte[] byArray = new byte[(int)l];
        TFileInputStream tFileInputStream = new TFileInputStream(file);
        try {
            new DataInputStream((InputStream)tFileInputStream).readFully(byArray);
        }
        finally {
            tFileInputStream.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    final void write(Node node, byte[] byArray) throws IOException {
        TFileOutputStream tFileOutputStream = new TFileOutputStream(node.file());
        try {
            tFileOutputStream.write(byArray);
        }
        finally {
            tFileOutputStream.close();
        }
    }
}

