/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import java.io.File;
import java.io.IOException;
import net.java.truelicense.maven.plugin.LoggerAdapter;
import net.java.truelicense.maven.plugin.MojoAdapter;
import net.java.truelicense.maven.plugin.Scope;
import net.java.truelicense.maven.plugin.obfuscation.Processor;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;

public abstract class ObfuscateClassesMojo
extends MojoAdapter {
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File buildDirectory;
    @Deprecated
    @Parameter(property="truelicense.obfuscate.backup", defaultValue="false")
    private boolean backup;
    @Deprecated
    @Parameter(property="truelicense.obfuscate.backupPrefix", defaultValue="classes")
    private String backupPrefix;
    @Deprecated
    @Parameter(property="truelicense.obfuscate.backupExtension", defaultValue="zip")
    private String backupExtension;
    @Parameter(property="truelicense.obfuscate.maxBytes", defaultValue="65536")
    private int maxBytes;
    @Parameter(property="truelicense.obfuscate.scope", defaultValue="annotated")
    private Scope scope;
    @Parameter(property="truelicense.obfuscate.methodNameFormat", defaultValue="_%s#%d")
    private String methodNameFormat;
    @Parameter(property="truelicense.obfuscate.intern", defaultValue="true")
    private boolean intern;

    protected abstract TFile outputDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void doExecute() throws MojoFailureException {
        block6: {
            try {
                if (this.scope == Scope.none) {
                    this.getLog().warn((CharSequence)"Skipping constant string value obfuscation.");
                    break block6;
                }
                this.getLog().info((CharSequence)String.format("Obfuscating %s constant string values in %s.", new Object[]{this.scope, this.outputDirectory()}));
                try {
                    this.backup();
                    this.obfuscate();
                }
                finally {
                    TVFS.umount();
                }
            }
            catch (Exception exception) {
                throw new MojoFailureException(exception.toString(), (Throwable)exception);
            }
        }
    }

    @Deprecated
    private void backup() throws IOException {
        if (!this.backup) {
            return;
        }
        TFile tFile = new TFile(File.createTempFile(this.backupPrefix + '.', '.' + this.backupExtension, this.buildDirectory));
        this.getLog().info((CharSequence)(tFile + ": Creating class file backup directory."));
        this.outputDirectory().cp_rp((File)tFile.rm_r());
    }

    private void obfuscate() {
        Processor.builder().logger((Logger)new LoggerAdapter(this.getLog())).directory((File)this.outputDirectory()).maxBytes(this.maxBytes).obfuscateAll(this.scope == Scope.all).methodNameFormat(this.methodNameFormat).internStrings(this.intern).build().run();
    }
}

