/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.maven.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import net.java.truelicense.maven.plugin.GenerateSourcesStrategy;
import net.java.truelicense.maven.plugin.JavaTool;
import net.java.truelicense.maven.plugin.LogChuteAdapter;
import net.java.truelicense.maven.plugin.MojoAdapter;
import net.java.truelicense.maven.plugin.ScalaTool;
import net.java.truelicense.maven.plugin.VersionTool;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.codehaus.plexus.util.FileUtils;

public abstract class GenerateSourcesMojo
extends MojoAdapter {
    private final JavaTool javaTool = new JavaTool();
    private final ScalaTool scalaTool = new ScalaTool();
    private final VersionTool versiontool = new VersionTool();
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter
    private Properties properties = new Properties();
    @Parameter(property="truelicense.generate.stripSuffix", defaultValue=".vtl")
    private String stripSuffix;
    private final ToolManager manager = new ToolManager();
    private VelocityEngine engine;

    @Override
    protected void doExecute() throws MojoFailureException {
        try {
            for (FileSet fileSet : this.fileSets()) {
                new TemplateSet(fileSet).processDirectory();
            }
        }
        catch (Exception exception) {
            throw new MojoFailureException(exception.toString(), (Throwable)exception);
        }
    }

    private List<FileSet> fileSets() {
        List<FileSet> list = this.templateSets();
        if (null == list) {
            list = new LinkedList<FileSet>();
            FileSet fileSet = new FileSet();
            fileSet.setDirectory(this.stripPrefix() + "java");
            fileSet.addInclude("**/*" + this.stripSuffix());
            list.add(fileSet);
        }
        return list;
    }

    VelocityEngine engine() {
        VelocityEngine velocityEngine = this.engine;
        return null != velocityEngine ? velocityEngine : (this.engine = this.engine0());
    }

    private VelocityEngine engine0() {
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("runtime.log.logsystem", (Object)new LogChuteAdapter(this.getLog()));
        velocityEngine.setProperty("file.resource.loader.path", (Object)this.baseDirectory().getPath());
        velocityEngine.init();
        return velocityEngine;
    }

    File baseDirectory() {
        return this.project.getBasedir();
    }

    static String list2csv(List<String> list) {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            stringBuilder.append(string).append(string2);
            string = ", ";
        }
        return stringBuilder.toString();
    }

    static void mkdirs(File file) throws IOException {
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException(file + ": Failed to create directories.");
        }
    }

    protected abstract GenerateSourcesStrategy generateSourcesStrategy();

    protected abstract List<FileSet> templateSets();

    protected abstract File outputDirectory();

    protected abstract String stripPrefix();

    protected String stripSuffix() {
        return this.stripSuffix;
    }

    final class TemplateSet {
        private final FileSet templates;
        private File mergeDirectory;

        TemplateSet(FileSet fileSet) {
            this.templates = fileSet;
        }

        void processDirectory() throws Exception {
            File file = this.resolveWithBaseDirectory(this.templateDirectoryPath());
            List list = FileUtils.getFileNames((File)file, (String)GenerateSourcesMojo.list2csv(this.templates.getIncludes()), (String)GenerateSourcesMojo.list2csv(this.templates.getExcludes()), (boolean)false);
            if (list.isEmpty()) {
                GenerateSourcesMojo.this.getLog().warn((CharSequence)(this.templates + " is empty."));
            } else {
                GenerateSourcesMojo.this.getLog().info((CharSequence)("Template directory: " + file));
                GenerateSourcesMojo.this.getLog().info((CharSequence)("Merge directory: " + this.mergeDirectory()));
                for (String string : list) {
                    this.processFile(string);
                }
                GenerateSourcesMojo.this.generateSourcesStrategy().updateProjectFrom(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFile(String string) throws Exception {
            Object object;
            String string2 = this.expandWithTemplateDirectoryPath(string);
            String string3 = this.stripSuffix(string);
            File file = this.resolveWithMergeDirectory(string3);
            if (GenerateSourcesMojo.this.getLog().isDebugEnabled()) {
                object = this.resolveWithBaseDirectory(string2);
                GenerateSourcesMojo.this.getLog().debug((CharSequence)("Template file: " + object));
                GenerateSourcesMojo.this.getLog().debug((CharSequence)("Merge file: " + file));
            }
            GenerateSourcesMojo.mkdirs(file.getParentFile());
            object = new OutputStreamWriter((OutputStream)new FileOutputStream(file), GenerateSourcesMojo.this.encoding);
            try {
                GenerateSourcesMojo.this.engine().getTemplate(string2, GenerateSourcesMojo.this.encoding).merge(this.context(), (Writer)object);
            }
            finally {
                ((Writer)object).close();
            }
        }

        private Context context() {
            ToolContext toolContext = GenerateSourcesMojo.this.manager.createContext();
            toolContext.put("java", (Object)GenerateSourcesMojo.this.javaTool);
            toolContext.put("project", (Object)GenerateSourcesMojo.this.project);
            toolContext.put("scala", (Object)GenerateSourcesMojo.this.scalaTool);
            toolContext.put("version", (Object)GenerateSourcesMojo.this.versiontool);
            for (Properties properties : new Properties[]{GenerateSourcesMojo.this.project.getProperties(), GenerateSourcesMojo.this.properties}) {
                for (String string : properties.stringPropertyNames()) {
                    toolContext.put(string, (Object)properties.getProperty(string));
                }
            }
            if (GenerateSourcesMojo.this.getLog().isDebugEnabled()) {
                this.debugContext((Context)toolContext);
            }
            return toolContext;
        }

        private void debugContext(Context context) {
            String string = "";
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : context.getKeys()) {
                stringBuilder.append(string).append(object.toString());
                string = ", ";
            }
            GenerateSourcesMojo.this.getLog().debug((CharSequence)("Populated a new Velocity context with the following keys: " + stringBuilder.toString()));
        }

        private String expandWithTemplateDirectoryPath(String string) {
            return this.templateDirectoryPath() + '/' + string;
        }

        private File resolveWithMergeDirectory(String string) {
            return new File(this.mergeDirectory(), string);
        }

        private File resolveWithBaseDirectory(String string) {
            return new File(GenerateSourcesMojo.this.baseDirectory(), string);
        }

        void addMergeDirectoryToCompileSourceRoot() {
            GenerateSourcesMojo.this.project.addCompileSourceRoot(this.pathOfMergeDirectory());
        }

        void addMergeDirectoryToTestCompileSourceRoot() {
            GenerateSourcesMojo.this.project.addTestCompileSourceRoot(this.pathOfMergeDirectory());
        }

        private String pathOfMergeDirectory() {
            return this.mergeDirectory().getPath();
        }

        private File mergeDirectory() {
            File file = this.mergeDirectory;
            return null != file ? file : (this.mergeDirectory = this.mergeDirectory0());
        }

        private File mergeDirectory0() {
            return this.resolveWithOutputDirectory(this.stripPrefix(this.templateDirectoryPath()));
        }

        private File resolveWithOutputDirectory(String string) {
            return new File(GenerateSourcesMojo.this.outputDirectory(), string);
        }

        private String templateDirectoryPath() {
            return this.templates.getDirectory();
        }

        private String stripPrefix(String string) {
            String string2 = GenerateSourcesMojo.this.stripPrefix();
            if (!string2.isEmpty() && string.startsWith(string2)) {
                String string3 = string.substring(string2.length());
                if (string3.isEmpty()) {
                    GenerateSourcesMojo.this.getLog().warn((CharSequence)(string + ": stripPrefix equals template directory - will not remove it."));
                } else {
                    return string3;
                }
            }
            return string;
        }

        private String stripSuffix(String string) {
            if (!GenerateSourcesMojo.this.stripSuffix.isEmpty() && string.endsWith(GenerateSourcesMojo.this.stripSuffix)) {
                String string2 = string.substring(0, string.length() - GenerateSourcesMojo.this.stripSuffix.length());
                if (string2.isEmpty() || string2.endsWith("/")) {
                    GenerateSourcesMojo.this.getLog().warn((CharSequence)(string + ": stripSuffix equals file name - will not remove it."));
                } else {
                    return string2;
                }
            }
            return string;
        }
    }
}

