/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import com.drew.metadata.Directory;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.ExifReader;
import it.tidalwave.image.metadata.EXIFLoader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class DrewEXIFLoader
extends EXIFLoader {
    public static int EXIF = 225;
    public static int IPTC = 237;

    public Object findEXIFNode(IIOMetadata metadata) {
        Node node = metadata.getAsTree(metadata.getNativeMetadataFormatName());
        return DrewEXIFLoader.getEXIFDirectory(node);
    }

    private static Directory getEXIFDirectory(Node node) {
        if (node.getNodeName().equals("unknown") && Integer.parseInt(node.getAttributes().getNamedItem("MarkerTag").getNodeValue()) == EXIF) {
            byte[] data = (byte[])((IIOMetadataNode)node).getUserObject();
            return new ExifReader(data).extract().getDirectory(ExifDirectory.class);
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Directory directory = DrewEXIFLoader.getEXIFDirectory(child);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }
}

